"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Easteregg = Easteregg;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const Bee = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./bee'))));
const ELK_BEE_REGEX = /^What\'s (an|(\d+)) elk bees?\?$/;
function Bees({
  query
}) {
  if (!query || typeof query !== 'object' || typeof query.query !== 'string') {
    return null;
  }
  const match = ELK_BEE_REGEX.exec(query.query);
  if (!match) {
    return null;
  }
  let amount = parseInt(match[2] || '1', 10);
  if (isNaN(amount)) {
    amount = 0;
  }
  amount = Math.max(1, Math.min(50, amount));
  return /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: false
  }, new Array(amount).fill(undefined).map((v, i) => /*#__PURE__*/_react.default.createElement(Bee, {
    key: i
  })));
}
function Easteregg(props) {
  return (
    /*#__PURE__*/
    // Do not break Lens for an easteregg
    _react.default.createElement(_eui.EuiErrorBoundary, {
      style: {
        display: 'none'
      }
    }, /*#__PURE__*/_react.default.createElement(Bees, props))
  );
}