"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.debouncedComponent = debouncedComponent;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * debouncedComponent wraps the specified React component, returning a component which
 * only renders once there is a pause in props changes for at least `delay` milliseconds.
 * During the debounce phase, it will return the previously rendered value.
 */
function debouncedComponent(component, delay = 256) {
  const MemoizedComponent = /*#__PURE__*/(0, _react.memo)(component);
  return props => {
    const [cachedProps, setCachedProps] = (0, _react.useState)(props);
    const debouncePropsChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(setCachedProps, delay), [setCachedProps]);

    // cancel debounced prop change if component has been unmounted in the meantime
    (0, _react.useEffect)(() => () => debouncePropsChange.cancel(), [debouncePropsChange]);
    debouncePropsChange(props);
    return /*#__PURE__*/_react.default.createElement(MemoizedComponent, cachedProps);
  };
}