"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Filtering = Filtering;
exports.setFilter = setFilter;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _operations = require("../operations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setFilter(columnId, layer, query) {
  return {
    ...layer,
    columns: {
      ...layer.columns,
      [columnId]: {
        ...layer.columns[columnId],
        filter: query
      }
    }
  };
}
function Filtering({
  selectedColumn,
  columnId,
  layer,
  updateLayer,
  indexPattern,
  helpMessage
}) {
  const inputFilter = selectedColumn.filter;
  const onChange = (0, _react.useCallback)(query => {
    const {
      isValid
    } = (0, _visualizationUiComponents.validateQuery)(query, indexPattern);
    if (isValid && !(0, _lodash.isEqual)(inputFilter, query)) {
      updateLayer(setFilter(columnId, layer, query));
    }
  }, [columnId, indexPattern, inputFilter, layer, updateLayer]);
  const lensServices = (0, _public.useKibana)().services;
  const selectedOperation = _operations.operationDefinitionMap[selectedColumn.operationType];
  if (!selectedOperation.filterable) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.FilterQueryInput, {
    helpMessage: helpMessage,
    onChange: onChange,
    dataView: indexPattern,
    inputFilter: inputFilter,
    queryInputServices: lensServices,
    appName: _constants.LENS_APP_NAME
  });
}