"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormBasedDimensionEditorComponent = exports.FormBasedDimensionEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/expression-xy-plugin/public");
var _dimension_editor = require("./dimension_editor");
var _operation_support = require("./operation_support");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormBasedDimensionEditorComponent = function FormBasedDimensionPanel(props) {
  var _props$state$layers$l;
  const layerId = props.layerId;
  const currentIndexPattern = props.indexPatterns[(_props$state$layers$l = props.state.layers[layerId]) === null || _props$state$layers$l === void 0 ? void 0 : _props$state$layers$l.indexPatternId];
  if (!currentIndexPattern) {
    return null;
  }
  const operationSupportMatrix = (0, _operation_support.getOperationSupportMatrix)(props);
  const selectedColumn = props.state.layers[layerId].columns[props.columnId] || null;
  return /*#__PURE__*/_react.default.createElement(_dimension_editor.DimensionEditor, (0, _extends2.default)({}, props, {
    layerType: props.layerType || _public.LayerTypes.DATA,
    currentIndexPattern: currentIndexPattern,
    selectedColumn: selectedColumn,
    operationSupportMatrix: operationSupportMatrix
  }));
};
exports.FormBasedDimensionEditorComponent = FormBasedDimensionEditorComponent;
const FormBasedDimensionEditor = /*#__PURE__*/(0, _react.memo)(FormBasedDimensionEditorComponent);
exports.FormBasedDimensionEditor = FormBasedDimensionEditor;