"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.supportedFormats = void 0;
var _common = require("@kbn/field-formats-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const supportedFormats = {
  number: {
    formatId: 'number',
    decimalsToPattern: (decimals = 2, compact) => {
      if (decimals === 0) {
        return `0,0${compact ? 'a' : ''}`;
      }
      return `0,0.${'0'.repeat(decimals)}${compact ? 'a' : ''}`;
    }
  },
  percent: {
    formatId: 'percent',
    decimalsToPattern: (decimals = 2, compact) => {
      if (decimals === 0) {
        return `0,0${compact ? 'a' : ''}%`;
      }
      return `0,0.${'0'.repeat(decimals)}${compact ? 'a' : ''}%`;
    }
  },
  bytes: {
    formatId: 'bytes',
    decimalsToPattern: (decimals = 2, compact) => {
      if (decimals === 0) {
        return `0,0b`;
      }
      return `0,0.${'0'.repeat(decimals)}b`;
    }
  },
  bits: {
    formatId: 'bytes',
    decimalsToPattern: (decimals = 2, compact) => {
      if (decimals === 0) {
        return `0,0bitd`;
      }
      return `0,0.${'0'.repeat(decimals)}bitd`;
    }
  },
  duration: {
    formatId: 'duration',
    decimalsToPattern: () => '',
    translateToFormatParams: params => {
      return {
        inputFormat: params.fromUnit || _common.DEFAULT_DURATION_INPUT_FORMAT.kind,
        outputFormat: params.toUnit || _common.DEFAULT_DURATION_OUTPUT_FORMAT.method,
        outputPrecision: params.decimals,
        useShortSuffix: Boolean(params.compact),
        showSuffix: true,
        includeSpaceWithSuffix: true
      };
    }
  },
  custom: {
    formatId: 'custom',
    decimalsToPattern: () => ''
  }
};
exports.supportedFormats = supportedFormats;