"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildGauge = buildGauge;
var _types = require("../types");
var _utils = require("../utils");
var _columns = require("../columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACCESSOR = 'metric_formula_accessor';
function getAccessorName(type) {
  return `${ACCESSOR}_${type}`;
}
function buildVisualizationState(config) {
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    layerType: 'data',
    ticksPosition: 'auto',
    shape: layer.shape || 'horizontalBullet',
    labelMajorMode: 'auto',
    metricAccessor: ACCESSOR,
    ...(layer.queryGoalValue ? {
      goalAccessor: getAccessorName('goal')
    } : {}),
    ...(layer.queryMaxValue ? {
      maxAccessor: getAccessorName('max'),
      showBar: true
    } : {}),
    ...(layer.queryMinValue ? {
      minAccessor: getAccessorName('min')
    } : {})
  };
}
function buildFormulaLayer(layer, i, dataView, formulaAPI) {
  const layers = {
    [_types.DEFAULT_LAYER_ID]: {
      ...(0, _columns.getFormulaColumn)(ACCESSOR, {
        value: layer.value
      }, dataView, formulaAPI)
    }
  };
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  if (layer.queryGoalValue) {
    const columnName = getAccessorName('goal');
    const formulaColumn = (0, _columns.getFormulaColumn)(columnName, {
      value: layer.queryGoalValue
    }, dataView, formulaAPI);
    (0, _utils.addLayerFormulaColumns)(defaultLayer, formulaColumn);
  }
  if (layer.queryMinValue) {
    const columnName = getAccessorName('min');
    const formulaColumn = (0, _columns.getFormulaColumn)(columnName, {
      value: layer.queryMinValue
    }, dataView, formulaAPI);
    (0, _utils.addLayerFormulaColumns)(defaultLayer, formulaColumn);
  }
  if (layer.queryMaxValue) {
    const columnName = getAccessorName('max');
    const formulaColumn = (0, _columns.getFormulaColumn)(columnName, {
      value: layer.queryMaxValue
    }, dataView, formulaAPI);
    (0, _utils.addLayerFormulaColumns)(defaultLayer, formulaColumn);
  }
  return defaultLayer;
}
function getValueColumns(layer) {
  return [(0, _columns.getValueColumn)(ACCESSOR, layer.value), ...(layer.queryMaxValue ? [(0, _columns.getValueColumn)(getAccessorName('max'), layer.queryMaxValue)] : []), ...(layer.queryMinValue ? [(0, _columns.getValueColumn)(getAccessorName('secondary'), layer.queryMinValue)] : []), ...(layer.queryGoalValue ? [(0, _columns.getValueColumn)(getAccessorName('secondary'), layer.queryGoalValue)] : [])];
}
async function buildGauge(config, {
  dataViewsAPI,
  formulaAPI
}) {
  const dataviews = {};
  const _buildFormulaLayer = (cfg, i, dataView) => buildFormulaLayer(cfg, i, dataView, formulaAPI);
  const datasourceStates = await (0, _utils.buildDatasourceStates)(config, dataviews, _buildFormulaLayer, getValueColumns, dataViewsAPI);
  return {
    title: config.title,
    visualizationType: 'lnsGauge',
    references: (0, _utils.buildReferences)(dataviews),
    state: {
      datasourceStates,
      internalReferences: [],
      filters: [],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: buildVisualizationState(config),
      // Getting the spec from a data view is a heavy operation, that's why the result is cached.
      adHocDataViews: (0, _utils.getAdhocDataviews)(dataviews)
    }
  };
}