"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricLayer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../../utils");
var _formula = require("./columns/formula");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const HISTOGRAM_COLUMN_NAME = 'x_date_histogram';
class MetricLayer {
  constructor(layerConfig) {
    var _layerConfig$layerTyp;
    (0, _defineProperty2.default)(this, "column", void 0);
    (0, _defineProperty2.default)(this, "layerConfig", void 0);
    this.column = new _formula.FormulaColumn(layerConfig.data);
    this.layerConfig = {
      ...layerConfig,
      layerType: (_layerConfig$layerTyp = layerConfig.layerType) !== null && _layerConfig$layerTyp !== void 0 ? _layerConfig$layerTyp : 'metricTrendline'
    };
  }
  getLayer(layerId, accessorId, chartDataView, formulaAPI) {
    var _this$layerConfig$dat, _this$layerConfig$dat2, _this$layerConfig$opt, _this$layerConfig$dat3;
    const baseLayer = {
      columnOrder: [HISTOGRAM_COLUMN_NAME],
      columns: (0, _utils.getHistogramColumn)({
        columnName: HISTOGRAM_COLUMN_NAME,
        options: {
          sourceField: ((_this$layerConfig$dat = this.layerConfig.dataView) !== null && _this$layerConfig$dat !== void 0 ? _this$layerConfig$dat : chartDataView).timeFieldName,
          params: {
            interval: 'auto',
            includeEmptyRows: true
          }
        }
      }),
      sampling: 1
    };
    return {
      [layerId]: {
        ...this.column.getData(accessorId, {
          columnOrder: [],
          columns: {}
        }, (_this$layerConfig$dat2 = this.layerConfig.dataView) !== null && _this$layerConfig$dat2 !== void 0 ? _this$layerConfig$dat2 : chartDataView, formulaAPI)
      },
      ...((_this$layerConfig$opt = this.layerConfig.options) !== null && _this$layerConfig$opt !== void 0 && _this$layerConfig$opt.showTrendLine ? {
        [`${layerId}_trendline`]: {
          linkToLayers: [layerId],
          ...this.column.getData(`${accessorId}_trendline`, baseLayer, (_this$layerConfig$dat3 = this.layerConfig.dataView) !== null && _this$layerConfig$dat3 !== void 0 ? _this$layerConfig$dat3 : chartDataView, formulaAPI)
        }
      } : {})
    };
  }
  getReference(layerId, chartDataView) {
    var _this$layerConfig$dat4, _this$layerConfig$dat5;
    return [...(0, _utils.getDefaultReferences)((_this$layerConfig$dat4 = this.layerConfig.dataView) !== null && _this$layerConfig$dat4 !== void 0 ? _this$layerConfig$dat4 : chartDataView, layerId), ...(0, _utils.getDefaultReferences)((_this$layerConfig$dat5 = this.layerConfig.dataView) !== null && _this$layerConfig$dat5 !== void 0 ? _this$layerConfig$dat5 : chartDataView, `${layerId}_trendline`)];
  }
  getLayerConfig(layerId, accessorId) {
    var _this$layerConfig$opt2;
    const {
      subtitle,
      backgroundColor,
      showTrendLine
    } = (_this$layerConfig$opt2 = this.layerConfig.options) !== null && _this$layerConfig$opt2 !== void 0 ? _this$layerConfig$opt2 : {};
    return {
      layerId,
      layerType: 'data',
      metricAccessor: accessorId,
      color: backgroundColor,
      subtitle,
      showBar: false,
      ...(showTrendLine ? {
        trendlineLayerId: `${layerId}_trendline`,
        trendlineLayerType: 'metricTrendline',
        trendlineMetricAccessor: `${accessorId}_trendline`,
        trendlineTimeAccessor: HISTOGRAM_COLUMN_NAME
      } : {})
    };
  }
  getName() {
    return this.column.getValueConfig().label;
  }
  getDataView() {
    return this.layerConfig.dataView;
  }
}
exports.MetricLayer = MetricLayer;