"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeState = decodeState;
exports.expandedStateToHashedState = expandedStateToHashedState;
exports.hashedStateToExpandedState = hashedStateToExpandedState;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _encode_state = require("../../../common/state_management/encode_state");
var _state_hash = require("../../../common/state_management/state_hash");
var _state_hash2 = require("../state_hash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// should be:
// export function decodeState<State extends RisonValue>(expandedOrHashedState: string)
// but this leads to the chain of types mismatches up to BaseStateContainer interfaces,
// as in state containers we don't have any restrictions on state shape
function decodeState(expandedOrHashedState) {
  if ((0, _state_hash.isStateHash)(expandedOrHashedState)) {
    return (0, _state_hash2.retrieveState)(expandedOrHashedState);
  } else {
    return _rison.default.decode(expandedOrHashedState);
  }
}
function hashedStateToExpandedState(expandedOrHashedState) {
  if ((0, _state_hash.isStateHash)(expandedOrHashedState)) {
    return (0, _encode_state.encodeState)((0, _state_hash2.retrieveState)(expandedOrHashedState), false, _state_hash2.persistState);
  }
  return expandedOrHashedState;
}
function expandedStateToHashedState(expandedOrHashedState) {
  if ((0, _state_hash.isStateHash)(expandedOrHashedState)) {
    return expandedOrHashedState;
  }
  return (0, _state_hash2.persistState)(decodeState(expandedOrHashedState));
}