"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExecutionContext = useExecutionContext;
var _useDeepCompareEffect = _interopRequireDefault(require("react-use/lib/useDeepCompareEffect"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Set and clean up application level execution context
 * @param executionContext
 * @param context
 */
function useExecutionContext(executionContext, context) {
  (0, _useDeepCompareEffect.default)(() => {
    executionContext === null || executionContext === void 0 ? void 0 : executionContext.set(context);
    return () => {
      executionContext === null || executionContext === void 0 ? void 0 : executionContext.clear();
    };
  }, [context]);
}