"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compare = compare;
exports.isValueChange = isValueChange;
var _lodash = require("lodash");
var _parse = require("../parse");
var _ast = require("./ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function isValueChange(value) {
  return (value === null || value === void 0 ? void 0 : value.type) === 'value';
}
function compare(expression, ast) {
  const astWithMeta = (0, _parse.parse)(expression, {
    addMeta: true
  });
  const queue = [[astWithMeta, ast]];
  const changes = [];
  function compareExpression(source, target) {
    (0, _lodash.zip)(source.node.chain, target.chain).forEach(([fnWithMeta, fn]) => {
      if (!fnWithMeta || !fn || (fnWithMeta === null || fnWithMeta === void 0 ? void 0 : fnWithMeta.node.function) !== (fn === null || fn === void 0 ? void 0 : fn.function)) {
        throw Error('Expression changes are not supported.');
      }
      compareFunction(fnWithMeta, fn);
    });
  }
  function compareFunction(source, target) {
    if ((0, _lodash.xor)(Object.keys(source.node.arguments), Object.keys(target.arguments)).length) {
      throw Error('Function changes are not supported.');
    }
    (0, _lodash.forEach)(source.node.arguments, (valuesWithMeta, argument) => {
      const values = target.arguments[argument];
      compareArgument(valuesWithMeta, values);
    });
  }
  function compareArgument(source, target) {
    if (source.length !== target.length) {
      throw Error('Arguments changes are not supported.');
    }
    (0, _lodash.zip)(source, target).forEach(([valueWithMeta, value]) => compareValue(valueWithMeta, value));
  }
  function compareValue(source, target) {
    if ((0, _ast.isAstWithMeta)(source) && (0, _ast.isAst)(target)) {
      compareExpression(source, target);
      return;
    }
    if (source.node !== target) {
      changes.push({
        type: 'value',
        source,
        target
      });
    }
  }
  while (queue.length) {
    compareExpression(...queue.shift());
  }
  return changes;
}