"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findClusters = findClusters;
var _eui = require("@elastic/eui");
var _local_cluster = require("./local_cluster");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function findClusters(request, query) {
  var _request$response, _request$response$jso;
  const rawResponse = (_request$response = request.response) === null || _request$response === void 0 ? void 0 : (_request$response$jso = _request$response.json) === null || _request$response$jso === void 0 ? void 0 : _request$response$jso.rawResponse;
  if (!rawResponse) {
    return {};
  }
  const clusters = rawResponse._clusters ? rawResponse._clusters.details : {
    [_local_cluster.LOCAL_CLUSTER_KEY]: (0, _local_cluster.getLocalClusterDetails)(rawResponse)
  };
  if (!query) {
    return clusters;
  }
  const clusterItems = Object.keys(clusters).map(key => {
    return {
      name: key,
      status: clusters[key].status
    };
  });
  const narrowedClusterItems = _eui.EuiSearchBar.Query.execute(query, clusterItems, {
    defaultFields: ['name']
  });
  const narrowedClusers = {};
  narrowedClusterItems.forEach(({
    name
  }) => {
    narrowedClusers[name] = clusters[name];
  });
  return narrowedClusers;
}