"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClustersTable = ClustersTable;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _cluster_view = require("./cluster_view");
var _clusters_health = require("../clusters_health");
var _local_cluster = require("../local_cluster");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getInitialExpandedRow(clusters) {
  const clusterNames = Object.keys(clusters);
  return clusterNames.length === 1 ? {
    [clusterNames[0]]: /*#__PURE__*/_react.default.createElement(_cluster_view.ClusterView, {
      clusterDetails: clusters[clusterNames[0]]
    })
  } : {};
}
function ClustersTable({
  clusters
}) {
  const [expandedRows, setExpandedRows] = (0, _react.useState)(getInitialExpandedRow(clusters));
  const [sortField, setSortField] = (0, _react.useState)();
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const toggleDetails = name => {
    const nextExpandedRows = {
      ...expandedRows
    };
    if (name in nextExpandedRows) {
      delete nextExpandedRows[name];
    } else {
      nextExpandedRows[name] = /*#__PURE__*/_react.default.createElement(_cluster_view.ClusterView, {
        clusterDetails: clusters[name]
      });
    }
    setExpandedRows(nextExpandedRows);
  };
  const items = (0, _react.useMemo)(() => {
    return Object.keys(clusters).map(key => {
      return {
        name: key,
        status: clusters[key].status,
        responseTime: clusters[key].took
      };
    });
  }, [clusters]);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('inspector.requests.clusters.table.nameLabel', {
      defaultMessage: 'Name'
    }),
    render: name => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleDetails(name),
        "aria-label": name in expandedRows ? _i18n.i18n.translate('inspector.requests.clusters.table.collapseRow', {
          defaultMessage: 'Collapse table row to hide cluster details'
        }) : _i18n.i18n.translate('inspector.requests.clusters.table.expandRow', {
          defaultMessage: 'Expand table row to view cluster details'
        }),
        iconType: name in expandedRows ? 'arrowDown' : 'arrowRight'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, name === _local_cluster.LOCAL_CLUSTER_KEY ? _i18n.i18n.translate('inspector.requests.clusters.table.localClusterDisplayName', {
        defaultMessage: 'Local cluster'
      }) : name));
    },
    sortable: items.length > 1,
    width: '60%'
  }, {
    field: 'status',
    name: _i18n.i18n.translate('inspector.requests.clusters.table.statusLabel', {
      defaultMessage: 'Status'
    }),
    render: status => {
      return /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
        status: status
      });
    },
    sortable: items.length > 1
  }, {
    align: 'right',
    field: 'responseTime',
    name: _i18n.i18n.translate('inspector.requests.clusters.table.responseTimeLabel', {
      defaultMessage: 'Response time'
    }),
    render: responseTime => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, responseTime ? _i18n.i18n.translate('inspector.requests.clusters.table.responseTimeInMilliseconds', {
      defaultMessage: '{responseTime}ms',
      values: {
        responseTime
      }
    }) : null),
    sortable: items.length > 1
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: sortField ? items.sort(_eui.Comparators.property(sortField, _eui.Comparators.default(sortDirection))) : items,
    isExpandable: true,
    itemIdToExpandedRowMap: expandedRows,
    itemId: "name",
    columns: columns,
    sorting: {
      sort: sortField ? {
        field: sortField,
        direction: sortDirection
      } : undefined
    },
    onChange: ({
      sort
    }) => {
      if (sort) {
        setSortField(sort.field);
        setSortDirection(sort.direction);
      }
    },
    noItemsMessage: _i18n.i18n.translate('inspector.requests.clusters.table.noItemsFound', {
      defaultMessage: 'No clusters found'
    })
  });
}