"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputControlVisRenderer = void 0;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const inputControlVisRegistry = new Map();
const getInputControlVisRenderer = deps => ({
  name: 'input_control_vis',
  reuseDomNode: true,
  render: async (domNode, {
    visConfig
  }, handlers) => {
    let registeredController = inputControlVisRegistry.get(domNode);
    if (!registeredController) {
      const {
        createInputControlVisController
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./vis_controller')));
      registeredController = createInputControlVisController(deps, handlers, domNode);
      inputControlVisRegistry.set(domNode, registeredController);
      handlers.onDestroy(() => {
        var _registeredController;
        (_registeredController = registeredController) === null || _registeredController === void 0 ? void 0 : _registeredController.destroy();
        inputControlVisRegistry.delete(domNode);
      });
    }
    await registeredController.render(visConfig);
    handlers.done();
  }
});
exports.getInputControlVisRenderer = getInputControlVisRenderer;