"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiService = exports.ApiService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../common/constants");
var _shared_imports = require("../../shared_imports");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ApiService {
  constructor() {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "uiMetricService", void 0);
  }
  useRequest(config) {
    if (!this.client) {
      throw new Error('Api service has not be initialized.');
    }
    return (0, _shared_imports.useRequest)(this.client, config);
  }
  sendRequest(config) {
    if (!this.client) {
      throw new Error('Api service has not be initialized.');
    }
    return (0, _shared_imports.sendRequest)(this.client, config);
  }
  trackUiMetric(eventName) {
    if (!this.uiMetricService) {
      throw new Error('UI metric service has not be initialized.');
    }
    return this.uiMetricService.trackUiMetric(eventName);
  }
  setup(httpClient, uiMetricService) {
    this.client = httpClient;
    this.uiMetricService = uiMetricService;
  }
  useLoadPipelines() {
    return this.useRequest({
      path: _constants.API_BASE_PATH,
      method: 'get'
    });
  }
  useLoadPipeline(name) {
    return this.useRequest({
      path: `${_constants.API_BASE_PATH}/${encodeURIComponent(name)}`,
      method: 'get'
    });
  }
  async createPipeline(pipeline) {
    const result = await this.sendRequest({
      path: _constants.API_BASE_PATH,
      method: 'post',
      body: JSON.stringify(pipeline)
    });
    this.trackUiMetric(_constants2.UIM_PIPELINE_CREATE);
    return result;
  }
  async updatePipeline(pipeline) {
    const {
      name,
      ...body
    } = pipeline;
    const result = await this.sendRequest({
      path: `${_constants.API_BASE_PATH}/${encodeURIComponent(name)}`,
      method: 'put',
      body: JSON.stringify(body)
    });
    this.trackUiMetric(_constants2.UIM_PIPELINE_UPDATE);
    return result;
  }
  async deletePipelines(names) {
    const result = this.sendRequest({
      path: `${_constants.API_BASE_PATH}/${names.map(name => encodeURIComponent(name)).join(',')}`,
      method: 'delete'
    });
    this.trackUiMetric(names.length > 1 ? _constants2.UIM_PIPELINE_DELETE_MANY : _constants2.UIM_PIPELINE_DELETE);
    return result;
  }
  async simulatePipeline(reqBody) {
    const result = await this.sendRequest({
      path: `${_constants.API_BASE_PATH}/simulate`,
      method: 'post',
      body: JSON.stringify(reqBody)
    });
    this.trackUiMetric(_constants2.UIM_PIPELINE_SIMULATE);
    return result;
  }
  async loadDocument(index, id) {
    const result = await this.sendRequest({
      path: `${_constants.API_BASE_PATH}/documents/${encodeURIComponent(index)}/${encodeURIComponent(id)}`,
      method: 'get'
    });
    return result;
  }
  async parseCsv(reqBody) {
    const result = await this.sendRequest({
      path: `${_constants.API_BASE_PATH}/parse_csv`,
      method: 'post',
      body: JSON.stringify(reqBody)
    });
    return result;
  }
}
exports.ApiService = ApiService;
const apiService = new ApiService();
exports.apiService = apiService;