"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _details_json_block = require("./details_json_block");
var _utils = require("../../lib/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineDetailsFlyout = ({
  pipeline,
  onClose,
  onEditClick,
  onCloneClick,
  onDeleteClick
}) => {
  var _pipeline$on_failure;
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const actionMenuItems = [
  /**
   * Edit pipeline
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.editActionLabel', {
      defaultMessage: 'Edit'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pencil"
    }),
    onClick: () => onEditClick(pipeline.name)
  },
  /**
   * Clone pipeline
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.cloneActionLabel', {
      defaultMessage: 'Clone'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "copy"
    }),
    onClick: () => onCloneClick(pipeline.name)
  },
  /**
   * Delete pipeline
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.deleteActionLabel', {
      defaultMessage: 'Delete'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "trash"
    }),
    onClick: () => {
      setShowPopover(false);
      onDeleteClick([pipeline.name]);
    }
  }];
  const managePipelineButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "managePipelineButton",
    "aria-label": _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.managePipelineActionsAriaLabel', {
      defaultMessage: 'Manage pipeline'
    }),
    onClick: () => setShowPopover(previousBool => !previousBool),
    iconType: "arrowUp",
    iconSide: "right",
    fill: true
  }, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.managePipelineButtonLabel', {
    defaultMessage: 'Manage'
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": "pipelineDetailsFlyoutTitle",
    "data-test-subj": "pipelineDetails",
    size: "m",
    maxWidth: 550
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    id: "pipelineDetailsFlyoutTitle",
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement("h2", null, pipeline.name))), pipeline.isManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.list.pipelineDetails.managedBadgeLabel",
    defaultMessage: "Managed"
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, pipeline.description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.descriptionTitle', {
    defaultMessage: 'Description'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, pipeline.description)), pipeline.version && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.versionTitle', {
    defaultMessage: 'Version'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, String(pipeline.version))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.processorsTitle', {
    defaultMessage: 'Processors'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_details_json_block.PipelineDetailsJsonBlock, {
    json: pipeline.processors
  })), ((_pipeline$on_failure = pipeline.on_failure) === null || _pipeline$on_failure === void 0 ? void 0 : _pipeline$on_failure.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.failureProcessorsTitle', {
    defaultMessage: 'Failure processors'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_details_json_block.PipelineDetailsJsonBlock, {
    json: pipeline.on_failure
  }))), pipeline._meta && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "metaTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.list.pipelineDetails.metaDescriptionListTitle",
    defaultMessage: "Metadata"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json"
  }, (0, _utils.stringifyJson)(pipeline._meta, false)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.closeButtonLabel', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: managePipelineButton,
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    "data-test-subj": "autoFollowPatternActionContextMenu",
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.managePipelinePanelTitle', {
        defaultMessage: 'Pipeline options'
      }),
      items: actionMenuItems
    }]
  })))))));
};
exports.PipelineDetailsFlyout = PipelineDetailsFlyout;