"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRedirectPath = useRedirectPath;
var _react = require("react");
var _shared_imports = require("../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook allow to redirect to the provided path or using redirect_path if it's provided in the query params.
 */
function useRedirectPath(history) {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const redirectPath = (0, _react.useMemo)(() => {
    const locationSearchParams = new URLSearchParams(history.location.search);
    return locationSearchParams.get('redirect_path');
  }, [history.location.search]);
  return (0, _react.useCallback)(path => {
    if (redirectPath) {
      services.application.navigateToUrl(redirectPath);
    } else {
      history.push(path);
    }
  }, [redirectPath, services.application, history]);
}