"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentsDropdown = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
require("./documents_dropdown.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  dropdownLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.documentsdropdown.dropdownLabel', {
    defaultMessage: 'Documents:'
  }),
  editDocumentsButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.documentsDropdown.editDocumentsButtonLabel', {
    defaultMessage: 'Edit documents'
  }),
  popoverTitle: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.documentsDropdown.popoverTitle', {
    defaultMessage: 'Test documents'
  })
};
const DocumentsDropdown = ({
  documents,
  selectedDocumentIndex,
  updateSelectedDocument,
  openFlyout
}) => {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const managePipelineButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "documentsButton",
    onClick: () => setShowPopover(previousBool => !previousBool),
    iconType: "arrowDown",
    iconSide: "right"
  }, _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.selectedDocumentLabel', {
    defaultMessage: 'Document {selectedDocument}',
    values: {
      selectedDocument: selectedDocumentIndex + 1
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: managePipelineButton,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    "data-test-subj": "documentsDropdown",
    panelClassName: "documentsDropdownPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    singleSelection: true,
    "data-test-subj": "documentList",
    options: documents.map((doc, index) => ({
      key: index.toString(),
      'data-test-subj': 'documentListItem',
      checked: selectedDocumentIndex === index ? 'on' : undefined,
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.documentLabel', {
        defaultMessage: 'Document {documentNumber}',
        values: {
          documentNumber: index + 1
        }
      })
    })),
    onChange: newOptions => {
      const selectedOption = newOptions.find(option => option.checked === 'on');
      if (selectedOption) {
        updateSelectedDocument(Number(selectedOption.key));
      }
      setShowPopover(false);
    }
  }, list => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, i18nTexts.popoverTitle), list)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fullWidth: true,
    onClick: () => {
      openFlyout('documents');
      setShowPopover(false);
    },
    "data-test-subj": "editDocumentsButton"
  }, i18nTexts.editDocumentsButtonLabel)));
};
exports.DocumentsDropdown = DocumentsDropdown;