"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XJsonEditor = void 0;
var _monaco = require("@kbn/monaco");
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../../../shared_imports");
var _text_editor = require("./text_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useXJsonMode
} = _shared_imports.XJson;
const defaultEditorOptions = {
  minimap: {
    enabled: false
  },
  lineNumbers: 'off'
};
const XJsonEditor = ({
  field,
  editorProps
}) => {
  const {
    value,
    setValue
  } = field;
  const {
    xJson,
    setXJson,
    convertToJson
  } = useXJsonMode(value);
  const onChange = (0, _react.useCallback)(s => {
    setXJson(s);
    setValue(convertToJson(s));
  }, [setValue, setXJson, convertToJson]);
  return /*#__PURE__*/_react.default.createElement(_text_editor.TextEditor, {
    field: field,
    editorProps: {
      value: xJson,
      languageId: _monaco.XJsonLang.ID,
      options: defaultEditorOptions,
      onChange,
      ...editorProps
    }
  });
};
exports.XJsonEditor = XJsonEditor;