"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditProcessorForm = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _context = require("../../context");
var _shared = require("../shared");
var _processor_settings_fields = require("./processor_settings_fields");
var _documentation_button = require("./documentation_button");
var _processor_output = require("./processor_output");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateButtonLabel = _i18n.i18n.translate('xpack.ingestPipelines.processorFormFlyout.updateButtonLabel', {
  defaultMessage: 'Update'
});
const cancelButtonLabel = _i18n.i18n.translate('xpack.ingestPipelines.processorFormFlyout.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const tabs = [{
  id: 'configuration',
  name: _i18n.i18n.translate('xpack.ingestPipelines.settingsFormOnFailureFlyout.configurationTabTitle', {
    defaultMessage: 'Configuration'
  })
}, {
  id: 'output',
  name: _i18n.i18n.translate('xpack.ingestPipelines.settingsFormOnFailureFlyout.outputTabTitle', {
    defaultMessage: 'Output'
  })
}];
const getFlyoutTitle = isOnFailure => {
  return isOnFailure ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.settingsFormOnFailureFlyout.manageOnFailureTitle",
    defaultMessage: "Manage on-failure processor"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.settingsFormOnFailureFlyout.manageTitle",
    defaultMessage: "Manage processor"
  });
};
const EditProcessorForm = ({
  getProcessor,
  form,
  isOnFailure,
  onOpen,
  esDocsBasePath,
  closeFlyout,
  handleSubmit,
  resetProcessors
}) => {
  const {
    testPipelineData,
    testPipelineDataDispatch
  } = (0, _context.useTestPipelineContext)();
  const {
    testOutputPerProcessor,
    config: {
      selectedDocumentIndex,
      documents
    },
    isExecutingPipeline
  } = testPipelineData;
  const processor = getProcessor();
  const processorOutput = processor && testOutputPerProcessor && testOutputPerProcessor[selectedDocumentIndex][processor.id];
  const updateSelectedDocument = index => {
    testPipelineDataDispatch({
      type: 'updateActiveDocument',
      payload: {
        config: {
          selectedDocumentIndex: index
        }
      }
    });
  };
  (0, _react.useEffect)(() => {
    onOpen();
  }, [] /* eslint-disable-line react-hooks/exhaustive-deps */);

  const [activeTab, setActiveTab] = (0, _react.useState)('configuration');
  let flyoutContent;
  if (activeTab === 'output') {
    flyoutContent = /*#__PURE__*/_react.default.createElement(_processor_output.ProcessorOutput, {
      processorOutput: processorOutput,
      documents: documents,
      selectedDocumentIndex: selectedDocumentIndex,
      updateSelectedDocument: updateSelectedDocument,
      isExecuting: isExecutingPipeline
    });
  } else {
    flyoutContent = /*#__PURE__*/_react.default.createElement(_processor_settings_fields.ProcessorSettingsFields, {
      processor: processor
    });
  }
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    "data-test-subj": "editProcessorForm",
    form: form,
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "m",
    maxWidth: 720,
    onClose: () => {
      resetProcessors();
      closeFlyout();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, getFlyoutTitle(isOnFailure))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "type"
  }, ({
    type
  }) => {
    const formDescriptor = (0, _shared.getProcessorDescriptor)(type);
    if (formDescriptor) {
      return /*#__PURE__*/_react.default.createElement(_documentation_button.DocumentationButton, {
        processorLabel: formDescriptor.label,
        docLink: esDocsBasePath + formDescriptor.docLinkPath
      });
    }
    return null;
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: async () => {
      // No need to do anything if user clicks the already active tab
      if (tab.id === activeTab) {
        return;
      }
      if (tab.id === 'output') {
        await handleSubmit(false);
      } else {
        form.reset({
          defaultValue: {
            fields: processor.options
          }
        });
      }
      setActiveTab(tab.id);
    },
    isSelected: tab.id === activeTab,
    key: tab.id,
    "data-test-subj": `${tab.id}Tab`,
    disabled: tab.id === 'output' && (Boolean(testOutputPerProcessor) === false || Boolean(processorOutput) === false)
  }, tab.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), flyoutContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      resetProcessors();
      closeFlyout();
    }
  }, cancelButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !form.isValid && form.isSubmitted || form.isSubmitting,
    "data-test-subj": "submitButton",
    onClick: async () => {
      if (activeTab === 'output') {
        return closeFlyout();
      }
      await handleSubmit();
    }
  }, updateButtonLabel))))));
};
exports.EditProcessorForm = EditProcessorForm;