"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllHosts = void 0;
var _rxjs = require("rxjs");
var _runtime_types = require("../../../../../common/runtime_types");
var _constants = require("../constants");
var _types = require("../types");
var _query = require("../helpers/query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllHosts = async ({
  searchClient,
  sourceConfig,
  params
}, hostNamesShortList = []) => {
  const query = createQuery(params, sourceConfig, hostNamesShortList);
  return (0, _rxjs.lastValueFrom)((0, _query.runQuery)(searchClient, query, (0, _runtime_types.decodeOrThrow)(_types.HostsMetricsSearchAggregationResponseRT)));
};
exports.getAllHosts = getAllHosts;
const createQuery = (params, sourceConfig, hostNamesShortList) => {
  const metricAggregations = (0, _query.getInventoryModelAggregations)(params.metrics.map(p => p.type));
  return {
    allow_no_indices: true,
    ignore_unavailable: true,
    index: sourceConfig.metricAlias,
    body: {
      size: 0,
      query: {
        bool: {
          filter: (0, _query.createFilters)({
            params,
            hostNamesShortList
          })
        }
      },
      aggs: createAggregations(params, metricAggregations)
    }
  };
};
const createAggregations = ({
  limit
}, metricAggregations) => {
  return {
    nodes: {
      terms: {
        field: _constants.BUCKET_KEY,
        size: limit !== null && limit !== void 0 ? limit : _constants.MAX_SIZE,
        order: {
          _key: 'asc'
        }
      },
      aggs: {
        ...metricAggregations,
        ..._constants.METADATA_AGGREGATION
      }
    }
  };
};