"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.METADATA_AGGREGATION_NAME = exports.METADATA_AGGREGATION = exports.MAX_SIZE = exports.INVENTORY_MODEL_NODE_TYPE = exports.FILTER_AGGREGATION_SUB_AGG_NAME = exports.BUCKET_KEY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUCKET_KEY = 'host.name';
exports.BUCKET_KEY = BUCKET_KEY;
const METADATA_AGGREGATION_NAME = 'metadata';
exports.METADATA_AGGREGATION_NAME = METADATA_AGGREGATION_NAME;
const FILTER_AGGREGATION_SUB_AGG_NAME = 'result';
exports.FILTER_AGGREGATION_SUB_AGG_NAME = FILTER_AGGREGATION_SUB_AGG_NAME;
const INVENTORY_MODEL_NODE_TYPE = 'host';
exports.INVENTORY_MODEL_NODE_TYPE = INVENTORY_MODEL_NODE_TYPE;
const MAX_SIZE = 500;
exports.MAX_SIZE = MAX_SIZE;
const METADATA_AGGREGATION = {
  [METADATA_AGGREGATION_NAME]: {
    top_metrics: {
      metrics: [{
        field: 'host.os.name'
      }, {
        field: 'cloud.provider'
      }, {
        field: 'host.ip'
      }],
      size: 1,
      sort: {
        '@timestamp': 'desc'
      }
    }
  }
};
exports.METADATA_AGGREGATION = METADATA_AGGREGATION;