"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AwsRDSLayout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _chart_section_vis = require("../chart_section_vis");
var _section = require("../section");
var _sub_section = require("../sub_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AwsRDSLayout = (0, _common.withTheme)(({
  metrics,
  onChangeRangeTime,
  theme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_section.Section, {
  navLabel: "AWS RDS",
  sectionLabel: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.overviewSection.sectionLabel', {
    defaultMessage: 'Aws RDS Overview'
  }),
  metrics: metrics,
  onChangeRangeTime: onChangeRangeTime
}, /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSCpuTotal",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.cpuTotal.sectionLabel', {
    defaultMessage: 'Total CPU Usage'
  })
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "area",
  formatter: "percent",
  seriesOverrides: {
    cpu: {
      color: theme.eui.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.cpuTotal.chartLabel', {
        defaultMessage: 'Total'
      })
    }
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSConnections",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.connections.sectionLabel', {
    defaultMessage: 'Connections'
  })
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "number",
  seriesOverrides: {
    connections: {
      color: theme.eui.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.connections.chartLabel', {
        defaultMessage: 'Connections'
      })
    }
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSQueriesExecuted",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.queriesExecuted.sectionLabel', {
    defaultMessage: 'Queries Executed'
  })
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "number",
  seriesOverrides: {
    queries: {
      color: theme.eui.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.queriesExecuted.chartLabel', {
        defaultMessage: 'Queries'
      })
    }
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSActiveTransactions",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.activeTransactions.sectionLabel', {
    defaultMessage: 'Transactions'
  })
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "number",
  seriesOverrides: {
    active: {
      color: theme.eui.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.active.chartLabel', {
        defaultMessage: 'Active'
      })
    },
    blocked: {
      color: theme.eui.euiColorVis2,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.blocked.chartLabel', {
        defaultMessage: 'Blocked'
      })
    }
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSLatency",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.sectionLabel', {
    defaultMessage: 'Latency'
  })
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  stacked: true,
  formatter: "highPrecision",
  formatterTemplate: '{{value}} ms',
  seriesOverrides: {
    read: {
      color: theme.eui.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.read.chartLabel', {
        defaultMessage: 'Read'
      })
    },
    write: {
      color: theme.eui.euiColorVis2,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.write.chartLabel', {
        defaultMessage: 'Write'
      })
    },
    insert: {
      color: theme.eui.euiColorVis0,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.insert.chartLabel', {
        defaultMessage: 'Insert'
      })
    },
    update: {
      color: theme.eui.euiColorVis7,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.update.chartLabel', {
        defaultMessage: 'Update'
      })
    },
    commit: {
      color: theme.eui.euiColorVis3,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.commit.chartLabel', {
        defaultMessage: 'Commit'
      })
    }
  }
})))));
exports.AwsRDSLayout = AwsRDSLayout;