"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailsFlyout = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../components/asset_details/types");
var _asset_details = _interopRequireDefault(require("../../../../../components/asset_details/asset_details"));
var _metrics_source = require("../../../../../containers/metrics_source");
var _asset_details_tabs = require("../../../../../common/asset_details_config/asset_details_tabs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flyoutTabs = [..._asset_details_tabs.commonFlyoutTabs, {
  id: _types.ContentTabIds.LINK_TO_APM,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.linkToApm', {
    defaultMessage: 'APM'
  })
}];
const ONE_HOUR = 60 * 60 * 1000;
const AssetDetailsFlyout = ({
  assetName,
  assetType,
  closeFlyout,
  currentTime,
  options,
  refreshInterval,
  isAutoReloading = false
}) => {
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const dateRange = (0, _react.useMemo)(() => {
    // forces relative dates when auto-refresh is active
    return isAutoReloading ? {
      from: 'now-1h',
      to: 'now'
    } : {
      from: new Date(currentTime - ONE_HOUR).toISOString(),
      to: new Date(currentTime).toISOString()
    };
  }, [currentTime, isAutoReloading]);
  return source ? /*#__PURE__*/_react.default.createElement(_asset_details.default, {
    assetId: assetName,
    assetName: assetName,
    assetType: assetType,
    overrides: {
      metadata: {
        showActionsColumn: false
      },
      alertRule: {
        options
      }
    },
    tabs: flyoutTabs,
    links: ['nodeDetails'],
    renderMode: {
      mode: 'flyout',
      closeFlyout
    },
    metricAlias: source.configuration.metricAlias,
    dateRange: dateRange,
    autoRefresh: {
      isPaused: !isAutoReloading,
      interval: refreshInterval
    }
  }) : null;
};
exports.AssetDetailsFlyout = AssetDetailsFlyout;