"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarItems = exports.Toolbar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _metrics_source = require("../../../../../containers/metrics_source");
var _use_inventory_meta = require("../../hooks/use_inventory_meta");
var _aws_ec2_toolbar_items = require("./aws_ec2_toolbar_items");
var _aws_rds_toolbar_items = require("./aws_rds_toolbar_items");
var _aws_s3_toolbar_items = require("./aws_s3_toolbar_items");
var _aws_sqs_toolbar_items = require("./aws_sqs_toolbar_items");
var _container_toolbar_items = require("./container_toolbar_items");
var _host_toolbar_items = require("./host_toolbar_items");
var _pod_toolbar_items = require("./pod_toolbar_items");
var _toolbar_wrapper = require("./toolbar_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Toolbar = ({
  nodeType,
  currentTime
}) => {
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const {
    accounts,
    regions
  } = (0, _use_inventory_meta.useInventoryMeta)(sourceId, nodeType, currentTime);
  return /*#__PURE__*/_react.default.createElement(_toolbar_wrapper.ToolbarWrapper, null, props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ToolbarItems, (0, _extends2.default)({}, props, {
    accounts: accounts,
    regions: regions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  })));
};
exports.Toolbar = Toolbar;
const ToolbarItems = props => {
  switch (props.nodeType) {
    case 'awsEC2':
      return /*#__PURE__*/_react.default.createElement(_aws_ec2_toolbar_items.AwsEC2ToolbarItems, props);
    case 'awsRDS':
      return /*#__PURE__*/_react.default.createElement(_aws_rds_toolbar_items.AwsRDSToolbarItems, props);
    case 'awsS3':
      return /*#__PURE__*/_react.default.createElement(_aws_s3_toolbar_items.AwsS3ToolbarItems, props);
    case 'awsSQS':
      return /*#__PURE__*/_react.default.createElement(_aws_sqs_toolbar_items.AwsSQSToolbarItems, props);
    case 'container':
      return /*#__PURE__*/_react.default.createElement(_container_toolbar_items.ContainerToolbarItems, props);
    case 'host':
      return /*#__PURE__*/_react.default.createElement(_host_toolbar_items.HostToolbarItems, props);
    case 'pod':
      return /*#__PURE__*/_react.default.createElement(_pod_toolbar_items.PodToolbarItems, props);
  }
};
exports.ToolbarItems = ToolbarItems;