"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSetupScreen = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _metrics_source = require("../../../../../../containers/metrics_source");
var _module = require("../../../../../../containers/ml/modules/metrics_k8s/module");
var _module2 = require("../../../../../../containers/ml/modules/metrics_hosts/module");
var _fixed_datepicker = require("../../../../../../components/fixed_datepicker");
var _module_descriptor = require("../../../../../../containers/ml/modules/metrics_k8s/module_descriptor");
var _kuery_bar = require("../../../../metrics_explorer/components/kuery_bar");
var _kuery = require("../../../../../../utils/kuery");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobSetupScreen = props => {
  const [now] = (0, _react.useState)(() => (0, _moment.default)());
  const {
    goHome
  } = props;
  const [startDate, setStartDate] = (0, _react.useState)(now.clone().subtract(4, 'weeks'));
  const [partitionField, setPartitionField] = (0, _react.useState)(null);
  const h = (0, _module2.useMetricHostsModuleContext)();
  const k = (0, _module.useMetricK8sModuleContext)();
  const [filter, setFilter] = (0, _react.useState)('');
  const [filterQuery, setFilterQuery] = (0, _react.useState)('');
  const trackMetric = (0, _public.useUiTracker)({
    app: 'infra_metrics'
  });
  const {
    createDerivedIndexPattern
  } = (0, _metrics_source.useSourceContext)();
  const indicies = h.sourceConfiguration.indices;
  const setupStatus = (0, _react.useMemo)(() => {
    if (props.jobType === 'kubernetes') {
      return k.setupStatus;
    } else {
      return h.setupStatus;
    }
  }, [props.jobType, k.setupStatus, h.setupStatus]);
  const cleanUpAndSetUpModule = (0, _react.useMemo)(() => {
    if (props.jobType === 'kubernetes') {
      return k.cleanUpAndSetUpModule;
    } else {
      return h.cleanUpAndSetUpModule;
    }
  }, [props.jobType, k.cleanUpAndSetUpModule, h.cleanUpAndSetUpModule]);
  const setUpModule = (0, _react.useMemo)(() => {
    if (props.jobType === 'kubernetes') {
      return k.setUpModule;
    } else {
      return h.setUpModule;
    }
  }, [props.jobType, k.setUpModule, h.setUpModule]);
  const hasSummaries = (0, _react.useMemo)(() => {
    if (props.jobType === 'kubernetes') {
      return k.jobSummaries.length > 0;
    } else {
      return h.jobSummaries.length > 0;
    }
  }, [props.jobType, k.jobSummaries, h.jobSummaries]);
  const derivedIndexPattern = (0, _react.useMemo)(() => createDerivedIndexPattern(), [createDerivedIndexPattern]);
  const updateStart = (0, _react.useCallback)(date => {
    setStartDate(date);
  }, []);
  const createJobs = (0, _react.useCallback)(() => {
    if (hasSummaries) {
      cleanUpAndSetUpModule(indicies, (0, _moment.default)(startDate).toDate().getTime(), undefined, filterQuery, partitionField ? partitionField[0] : undefined);
    } else {
      setUpModule(indicies, (0, _moment.default)(startDate).toDate().getTime(), undefined, filterQuery, partitionField ? partitionField[0] : undefined);
    }
  }, [cleanUpAndSetUpModule, filterQuery, setUpModule, hasSummaries, indicies, partitionField, startDate]);
  const onFilterChange = (0, _react.useCallback)(f => {
    setFilter(f || '');
    setFilterQuery((0, _kuery.convertKueryToElasticSearchQuery)(f, derivedIndexPattern) || '');
  }, [derivedIndexPattern]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedOnFilterChange = (0, _react.useCallback)((0, _lodash.debounce)(onFilterChange, 500), [onFilterChange]);
  const onPartitionFieldChange = (0, _react.useCallback)(value => {
    setPartitionField(value.map(v => v.label));
  }, []);
  (0, _react.useEffect)(() => {
    if (props.jobType === 'kubernetes') {
      setPartitionField([_module_descriptor.DEFAULT_K8S_PARTITION_FIELD]);
    }
  }, [props.jobType]);
  (0, _react.useEffect)(() => {
    if (setupStatus.type === 'succeeded') {
      if (props.jobType === 'kubernetes') {
        trackMetric({
          metric: 'metrics_ml_anomaly_detection_k8s_enabled'
        });
        if (partitionField && (partitionField.length !== 1 || partitionField[0] !== _module_descriptor.DEFAULT_K8S_PARTITION_FIELD)) {
          trackMetric({
            metric: 'metrics_ml_anomaly_detection_k8s_partition_changed'
          });
        }
      } else {
        trackMetric({
          metric: 'metrics_ml_anomaly_detection_hosts_enabled'
        });
        if (partitionField) {
          trackMetric({
            metric: 'metrics_ml_anomaly_detection_hosts_partition_changed'
          });
        }
        trackMetric({
          metric: 'metrics_ml_anomaly_detection_hosts_enabled'
        });
      }
      goHome();
    }
  }, [setupStatus, props.jobType, partitionField, trackMetric, goHome]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Enable machine learning for {nodeType}",
    id: "xpack.infra.ml.aomalyFlyout.jobSetup.flyoutHeader",
    values: {
      nodeType: props.jobType
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, setupStatus.type === 'pending' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.loadingText",
    defaultMessage: "Creating ML job..."
  }))) : setupStatus.type === 'failed' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.failureText",
    defaultMessage: "Something went wrong creating the necessary ML jobs."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), setupStatus.reasons.map((errorMessage, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    key: i,
    color: "danger",
    iconType: "warning",
    title: errorCalloutTitle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    transparentBackground: true
  }, errorMessage))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraJobSetupScreenTryAgainButton",
    fill: true,
    onClick: createJobs
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.tryAgainButton",
    defaultMessage: "Try again"
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.description",
    defaultMessage: "Settings can not be changed once the jobs are created. You can recreate jobs anytime, however, the previously detected anomalies are removed."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.when.title",
      defaultMessage: "When does your model begin?"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.when.description",
      defaultMessage: "By default, machine learning jobs analyze the last 4 weeks of data and continue to run indefinitely."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.when.timePicker.label",
      defaultMessage: "Start date"
    })
  }, /*#__PURE__*/_react.default.createElement(_fixed_datepicker.FixedDatePicker, {
    showTimeSelect: true,
    selected: startDate,
    onChange: updateStart,
    maxDate: now
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.partition.title",
      defaultMessage: "How do you want to partition your data?"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.partition.description",
      defaultMessage: "Partitions enable you to build independent models for groups of data that share similar behavior. For example, you can partition by machine type or cloud availability zone."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.partition.label",
      defaultMessage: "Partition field"
    }),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.infra.metricsExplorer.groupByLabel', {
      defaultMessage: 'Everything'
    }),
    "aria-label": _i18n.i18n.translate('xpack.infra.metricsExplorer.groupByAriaLabel', {
      defaultMessage: 'Graph per'
    }),
    fullWidth: true,
    singleSelection: true,
    selectedOptions: partitionField ? partitionField.map(p => ({
      label: p
    })) : undefined,
    options: derivedIndexPattern.fields.filter(f => f.aggregatable && f.type === 'string').map(f => ({
      label: f.name
    })),
    onChange: onPartitionFieldChange,
    isClearable: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.filter.title",
      defaultMessage: "Filter"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.filter.description",
      defaultMessage: "By default, machine learning jobs analyze all of your metric data."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.filter.label",
      defaultMessage: "Filter (optional)"
    })
  }, /*#__PURE__*/_react.default.createElement(_kuery_bar.MetricsExplorerKueryBar, {
    derivedIndexPattern: derivedIndexPattern,
    onSubmit: onFilterChange,
    onChange: debouncedOnFilterChange,
    value: filter
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraJobSetupScreenCancelButton",
    onClick: props.closeFlyout
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.cancelButton",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraJobSetupScreenEnableJobsButton",
    fill: true,
    fullWidth: false,
    onClick: createJobs
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.enableButton",
    defaultMessage: "Enable jobs"
  }))))));
};
exports.JobSetupScreen = JobSetupScreen;
const errorCalloutTitle = _i18n.i18n.translate('xpack.infra.ml.steps.setupProcess.errorCalloutTitle', {
  defaultMessage: 'An error occurred'
});