"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUnifiedSearchContext = exports.useUnifiedSearch = exports.UnifiedSearchProvider = exports.UnifiedSearch = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _operators = require("rxjs/operators");
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _datemath = require("../../../../utils/datemath");
var _use_kibana_query_settings = require("../../../../utils/use_kibana_query_settings");
var _use_kibana = require("../../../../hooks/use_kibana");
var _telemetry_time_range = require("../../../../../common/formatters/telemetry_time_range");
var _use_data_view = require("./use_data_view");
var _use_unified_search_url_state = require("./use_unified_search_url_state");
var _build = require("../../../../utils/filters/build");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildQuerySubmittedPayload = hostState => {
  const {
    panelFilters,
    filters,
    parsedDateRange,
    query: queryObj,
    limit
  } = hostState;
  return {
    control_filter_fields: (0, _build.retrieveFieldsFromFilter)(panelFilters),
    filter_fields: (0, _build.retrieveFieldsFromFilter)(filters),
    interval: (0, _telemetry_time_range.telemetryTimeRangeFormatter)(parsedDateRange.to - parsedDateRange.from),
    with_query: !!queryObj.query,
    limit
  };
};
const DEFAULT_FROM_IN_MILLISECONDS = 15 * 60000;
const getDefaultTimestamps = () => {
  const now = Date.now();
  return {
    from: new Date(now - DEFAULT_FROM_IN_MILLISECONDS).toISOString(),
    to: new Date(now).toISOString()
  };
};
const useUnifiedSearch = () => {
  const [error, setError] = (0, _react.useState)(null);
  const [searchCriteria, setSearch] = (0, _use_unified_search_url_state.useHostsUrlState)();
  const {
    dataView
  } = (0, _use_data_view.useMetricsDataViewContext)();
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const kibanaQuerySettings = (0, _use_kibana_query_settings.useKibanaQuerySettings)();
  const {
    data: {
      query: {
        filterManager: filterManagerService,
        queryString: queryStringService,
        timefilter: timeFilterService
      }
    },
    telemetry
  } = services;
  const validateQuery = (0, _react.useCallback)(query => {
    (0, _esQuery.fromKueryExpression)(query.query, kibanaQuerySettings);
  }, [kibanaQuerySettings]);
  const onSubmit = (0, _react.useCallback)(params => {
    try {
      var _params$query;
      setError(null);
      /* 
      / Validates the Search Bar input values before persisting them in the state.
      / Since the search can be triggered by components that are unaware of the Unified Search state (e.g Controls and Host Limit),
      / this will always validates the query bar value, regardless of whether it's been sent in the current event or not.
      */
      validateQuery((_params$query = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query !== void 0 ? _params$query : queryStringService.getQuery());
      setSearch(params !== null && params !== void 0 ? params : {});
    } catch (err) {
      /* 
      / Persists in the state the params so they can be used in case the query bar is fixed by the user.
      / This is needed because the Unified Search observables are unnaware of the other componets in the search bar.
      / Invalid query isn't persisted because it breaks the Control component
      */
      const {
        query,
        ...validParams
      } = params !== null && params !== void 0 ? params : {};
      setSearch(validParams !== null && validParams !== void 0 ? validParams : {});
      setError(err);
    }
  }, [queryStringService, setSearch, validateQuery]);
  const parsedDateRange = (0, _react.useMemo)(() => {
    const defaults = getDefaultTimestamps();
    const {
      from = defaults.from,
      to = defaults.to
    } = (0, _datemath.parseDateRange)(searchCriteria.dateRange);
    return {
      from,
      to
    };
  }, [searchCriteria.dateRange]);
  const getDateRangeAsTimestamp = (0, _react.useCallback)(() => {
    const from = new Date(parsedDateRange.from).getTime();
    const to = new Date(parsedDateRange.to).getTime();
    return {
      from,
      to
    };
  }, [parsedDateRange]);
  const buildQuery = (0, _react.useCallback)(() => {
    return (0, _esQuery.buildEsQuery)(dataView, searchCriteria.query, [...searchCriteria.filters, ...searchCriteria.panelFilters], kibanaQuerySettings);
  }, [dataView, searchCriteria.query, searchCriteria.filters, searchCriteria.panelFilters, kibanaQuerySettings]);
  (0, _useEffectOnce.default)(() => {
    // Sync filtersService from the URL state
    if (!(0, _fastDeepEqual.default)(filterManagerService.getFilters(), searchCriteria.filters)) {
      filterManagerService.setFilters(searchCriteria.filters);
    }
    // Sync queryService from the URL state
    if (!(0, _fastDeepEqual.default)(queryStringService.getQuery(), searchCriteria.query)) {
      queryStringService.setQuery(searchCriteria.query);
    }
    try {
      // Validates the "query" object from the URL state
      if (searchCriteria.query) {
        validateQuery(searchCriteria.query);
      }
    } catch (err) {
      setError(err);
    }
  });
  (0, _react.useEffect)(() => {
    const filters$ = filterManagerService.getUpdates$().pipe((0, _operators.startWith)(undefined), (0, _operators.map)(() => filterManagerService.getFilters()));
    const query$ = queryStringService.getUpdates$().pipe((0, _operators.startWith)(undefined), (0, _operators.map)(() => queryStringService.getQuery()));
    const subscription = (0, _rxjs.combineLatest)({
      filters: filters$,
      query: query$
    }).pipe((0, _operators.skip)(1)).subscribe(onSubmit);
    return () => {
      subscription.unsubscribe();
    };
  }, [filterManagerService, onSubmit, queryStringService, timeFilterService.timefilter]);

  // Track telemetry event on query/filter/date changes
  (0, _react.useEffect)(() => {
    const dateRangeInTimestamp = getDateRangeAsTimestamp();
    telemetry.reportHostsViewQuerySubmitted(buildQuerySubmittedPayload({
      ...searchCriteria,
      parsedDateRange: dateRangeInTimestamp
    }));
  }, [getDateRangeAsTimestamp, searchCriteria, telemetry]);
  return {
    error,
    buildQuery,
    onSubmit,
    parsedDateRange,
    getDateRangeAsTimestamp,
    searchCriteria
  };
};
exports.useUnifiedSearch = useUnifiedSearch;
const UnifiedSearch = (0, _constate.default)(useUnifiedSearch);
exports.UnifiedSearch = UnifiedSearch;
const [UnifiedSearchProvider, useUnifiedSearchContext] = UnifiedSearch;
exports.useUnifiedSearchContext = useUnifiedSearchContext;
exports.UnifiedSearchProvider = UnifiedSearchProvider;