"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsQueryImpl = exports.useAlertsQuery = exports.AlertsQueryProvider = exports.AlertsQueryContainer = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _create_alerts_es_query = require("../../../../common/alerts/create_alerts_es_query");
var _use_unified_search = require("./use_unified_search");
var _use_hosts_view = require("./use_hosts_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertsQueryImpl = () => {
  const {
    hostNodes
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const [alertStatus, setAlertStatus] = (0, _react.useState)('all');
  const hostNodeNames = (0, _react.useMemo)(() => hostNodes.map(n => n.name), [hostNodes]);
  const getAlertsEsQuery = (0, _react.useCallback)(status => (0, _create_alerts_es_query.createAlertsEsQuery)({
    dateRange: searchCriteria.dateRange,
    hostNodeNames,
    status
  }), [hostNodeNames, searchCriteria.dateRange]);

  // Regenerate the query when status change even if is not used.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const alertsEsQuery = (0, _react.useMemo)(() => getAlertsEsQuery(), [getAlertsEsQuery, alertStatus]);
  const alertsEsQueryByStatus = (0, _react.useMemo)(() => getAlertsEsQuery(alertStatus), [getAlertsEsQuery, alertStatus]);
  return {
    alertStatus,
    setAlertStatus,
    alertsEsQuery,
    alertsEsQueryByStatus
  };
};
exports.useAlertsQueryImpl = useAlertsQueryImpl;
const AlertsQueryContainer = (0, _constate.default)(useAlertsQueryImpl);
exports.AlertsQueryContainer = AlertsQueryContainer;
const [AlertsQueryProvider, useAlertsQuery] = AlertsQueryContainer;
exports.useAlertsQuery = useAlertsQuery;
exports.AlertsQueryProvider = AlertsQueryProvider;