"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/visualizations/constants");
var _lens = require("../../../../../../components/lens");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _build = require("../../../../../../utils/filters/build");
var _use_hosts_table = require("../../../hooks/use_hosts_table");
var _use_after_loaded_state = require("../../../hooks/use_after_loaded_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Chart = ({
  dataView,
  ...chartProps
}) => {
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    loading,
    searchSessionId
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    currentPage
  } = (0, _use_hosts_table.useHostsTableContext)();
  const shouldUseSearchCriteria = currentPage.length === 0;

  // prevents searchCriteria state from reloading the chart
  // we want it to reload only once the table has finished loading.
  // attributes passed to useAfterLoadedState don't need to be memoized
  const {
    afterLoadedState
  } = (0, _use_after_loaded_state.useAfterLoadedState)(loading, {
    dateRange: searchCriteria.dateRange,
    query: shouldUseSearchCriteria ? searchCriteria.query : undefined,
    searchSessionId
  });
  const filters = (0, _react.useMemo)(() => {
    return shouldUseSearchCriteria ? searchCriteria.filters : [(0, _build.buildCombinedHostsFilter)({
      field: 'host.name',
      values: currentPage.map(p => p.name),
      dataView
    })];
  }, [searchCriteria.filters, currentPage, dataView, shouldUseSearchCriteria]);
  return /*#__PURE__*/_react.default.createElement(_lens.LensChart, (0, _extends2.default)({}, chartProps, {
    id: `hostsView-metricChart-${chartProps.id}`,
    borderRadius: "m",
    dataView: dataView,
    dateRange: afterLoadedState.dateRange,
    height: _constants.METRIC_CHART_HEIGHT,
    loading: loading,
    filters: filters,
    query: afterLoadedState.query,
    searchSessionId: afterLoadedState.searchSessionId
  }));
};
exports.Chart = Chart;