"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualisationContent = exports.AnomaliesSwimlaneVisualisation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/ml-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _infra_ml = require("../../../../../../common/infra_ml");
var _missing_embeddable_factory_callout = require("../../../../../components/missing_embeddable_factory_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Disable refresh, allow our timerange changes to refresh the embeddable.
const REFRESH_CONFIG = {
  pause: true,
  value: 0
};
const AnomaliesSwimlaneVisualisation = props => {
  const {
    embeddable: embeddablePlugin
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  if (!embeddablePlugin) return null;
  return /*#__PURE__*/_react.default.createElement(VisualisationContent, props);
};
exports.AnomaliesSwimlaneVisualisation = AnomaliesSwimlaneVisualisation;
const VisualisationContent = ({
  timeRange,
  jobIds,
  selectedDatasets
}) => {
  const {
    embeddable: embeddablePlugin
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const factory = embeddablePlugin === null || embeddablePlugin === void 0 ? void 0 : embeddablePlugin.getEmbeddableFactory(_public.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE);
  const embeddableInput = (0, _react.useMemo)(() => {
    return {
      id: 'LOG_ENTRY_ANOMALIES_EMBEDDABLE_INSTANCE',
      // NOTE: This is the only embeddable on the anomalies page, a static string will do.
      jobIds,
      swimlaneType: 'viewBy',
      timeRange: {
        from: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        to: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ')
      },
      refreshConfig: REFRESH_CONFIG,
      viewBy: _infra_ml.partitionField,
      filters: [],
      query: {
        language: 'kuery',
        query: selectedDatasets.map(dataset => `${_infra_ml.partitionField} : ${dataset !== '' ? dataset : '""'}`).join(' or ') // Ensure unknown (those with an empty "" string) datasets are handled correctly.
      }
    };
  }, [jobIds, timeRange.startTime, timeRange.endTime, selectedDatasets]);
  if (!factory) {
    return /*#__PURE__*/_react.default.createElement(_missing_embeddable_factory_callout.MissingEmbeddableFactoryCallout, {
      embeddableType: _public.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE
    });
  }
  return /*#__PURE__*/_react.default.createElement(_public2.EmbeddableRenderer, {
    input: embeddableInput,
    factory: factory
  });
};
exports.VisualisationContent = VisualisationContent;