"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exampleTimestampFormat = exports.exampleMessageScale = exports.exampleMessageColumnConfigurations = exports.CategoryExampleMessage = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/logs-shared-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _rison = require("@kbn/rison");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _log_analysis = require("../../../../../../common/log_analysis");
var _view_log_in_context = require("../../../../../containers/logs/view_log_in_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exampleMessageScale = 'medium';
exports.exampleMessageScale = exampleMessageScale;
const exampleTimestampFormat = 'dateTime';
exports.exampleTimestampFormat = exampleTimestampFormat;
const CategoryExampleMessage = ({
  id,
  dataset,
  message,
  timestamp,
  timeRange,
  tiebreaker,
  context
}) => {
  const trackMetric = (0, _public2.useUiTracker)({
    app: 'infra_logs'
  });
  const [, {
    setContextEntry
  }] = (0, _view_log_in_context.useViewLogInProviderContext)();
  // handle special cases for the dataset value
  const humanFriendlyDataset = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset);
  const [isHovered, setIsHovered] = (0, _react.useState)(false);
  const setHovered = (0, _react.useCallback)(() => setIsHovered(true), []);
  const setNotHovered = (0, _react.useCallback)(() => setIsHovered(false), []);
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const openMenu = (0, _react.useCallback)(() => setIsMenuOpen(true), []);
  const closeMenu = (0, _react.useCallback)(() => setIsMenuOpen(false), []);
  const viewInStreamLinkProps = (0, _public2.useLinkProps)({
    app: 'logs',
    pathname: 'stream',
    search: {
      logPosition: (0, _rison.encode)({
        end: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        position: {
          tiebreaker,
          time: (0, _moment.default)(timestamp).toISOString()
        },
        start: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        streamLive: false
      }),
      flyoutOptions: (0, _rison.encode)({
        surroundingLogsId: id
      }),
      logFilter: (0, _rison.encode)({
        expression: `${_log_analysis.partitionField}: ${dataset}`,
        kind: 'kuery'
      })
    }
  });
  return /*#__PURE__*/_react.default.createElement(_public.LogEntryRowWrapper, {
    scale: exampleMessageScale,
    onMouseEnter: setHovered,
    onMouseLeave: setNotHovered
  }, /*#__PURE__*/_react.default.createElement(_public.LogEntryColumn, columnWidths[timestampColumnId], /*#__PURE__*/_react.default.createElement(_public.LogEntryTimestampColumn, {
    format: exampleTimestampFormat,
    time: timestamp
  })), /*#__PURE__*/_react.default.createElement(_public.LogEntryColumn, columnWidths[messageColumnId], /*#__PURE__*/_react.default.createElement(_public.LogEntryMessageColumn, {
    columnValue: {
      columnId: messageColumnId,
      message: [{
        field: 'message',
        value: [message],
        highlights: []
      }]
    },
    highlights: noHighlights,
    isActiveHighlight: false,
    wrapMode: "none"
  })), /*#__PURE__*/_react.default.createElement(_public.LogEntryColumn, columnWidths[datasetColumnId], /*#__PURE__*/_react.default.createElement(_public.LogEntryFieldColumn, {
    columnValue: {
      columnId: datasetColumnId,
      field: 'event.dataset',
      value: [humanFriendlyDataset],
      highlights: []
    },
    highlights: noHighlights,
    isActiveHighlight: false,
    wrapMode: "none"
  })), /*#__PURE__*/_react.default.createElement(_public.LogEntryColumn, columnWidths[iconColumnId], isHovered || isMenuOpen ? /*#__PURE__*/_react.default.createElement(_public.LogEntryContextMenu, {
    isOpen: isMenuOpen,
    onOpen: openMenu,
    onClose: closeMenu,
    items: [{
      label: _i18n.i18n.translate('xpack.infra.logs.categoryExample.viewInStreamText', {
        defaultMessage: 'View in stream'
      }),
      onClick: viewInStreamLinkProps.onClick,
      href: viewInStreamLinkProps.href
    }, {
      label: _i18n.i18n.translate('xpack.infra.logs.categoryExample.viewInContextText', {
        defaultMessage: 'View in context'
      }),
      onClick: () => {
        const logEntry = {
          id,
          index: '',
          // TODO: use real index when loading via async search
          context,
          cursor: {
            time: (0, _moment.default)(timestamp).toISOString(),
            tiebreaker
          },
          columns: []
        };
        trackMetric({
          metric: 'view_in_context__categories'
        });
        setContextEntry(logEntry);
      }
    }]
  }) : null));
};
exports.CategoryExampleMessage = CategoryExampleMessage;
const noHighlights = [];
const timestampColumnId = 'category-example-timestamp-column';
const messageColumnId = 'category-examples-message-column';
const datasetColumnId = 'category-examples-dataset-column';
const iconColumnId = 'category-examples-icon-column';
const columnWidths = {
  [timestampColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    // w_count + w_trend - w_padding = 120 px + 220 px - 8 px
    baseWidth: '332px'
  },
  [messageColumnId]: {
    growWeight: 1,
    shrinkWeight: 0,
    baseWidth: '0%'
  },
  [datasetColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    // w_dataset + w_max_anomaly + w_expand - w_padding = 200 px + 160 px + 40 px + 40 px - 8 px
    baseWidth: '400px'
  },
  [iconColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    baseWidth: '32px'
  }
};
const exampleMessageColumnConfigurations = [{
  timestampColumn: {
    id: timestampColumnId
  }
}, {
  messageColumn: {
    id: messageColumnId
  }
}, {
  fieldColumn: {
    field: 'event.dataset',
    id: datasetColumnId
  }
}];
exports.exampleMessageColumnConfigurations = exampleMessageColumnConfigurations;