"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryDetailsRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _log_analysis = require("../../../../../../common/log_analysis");
var _use_log_entry_category_examples = require("../../use_log_entry_category_examples");
var _log_entry_examples = require("../../../../../components/logging/log_entry_examples/log_entry_examples");
var _category_example_message = require("./category_example_message");
var _use_log_ml_job_id_formats_shim = require("../../../shared/use_log_ml_job_id_formats_shim");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exampleCount = 5;
const CategoryDetailsRow = ({
  categoryId,
  timeRange,
  logViewReference
}) => {
  const {
    idFormats
  } = (0, _use_log_ml_job_id_formats_shim.useLogMlJobIdFormatsShimContext)();
  const {
    getLogEntryCategoryExamples,
    hasFailedLoadingLogEntryCategoryExamples,
    isLoadingLogEntryCategoryExamples,
    logEntryCategoryExamples
  } = (0, _use_log_entry_category_examples.useLogEntryCategoryExamples)({
    categoryId,
    endTime: timeRange.endTime,
    exampleCount,
    logViewReference,
    idFormat: idFormats === null || idFormats === void 0 ? void 0 : idFormats[_log_analysis.logEntryCategoriesJobType],
    startTime: timeRange.startTime
  });
  (0, _react.useEffect)(() => {
    getLogEntryCategoryExamples();
  }, [getLogEntryCategoryExamples]);
  return /*#__PURE__*/_react.default.createElement(_log_entry_examples.LogEntryExampleMessages, {
    isLoading: isLoadingLogEntryCategoryExamples,
    hasFailedLoading: hasFailedLoadingLogEntryCategoryExamples,
    hasResults: logEntryCategoryExamples.length > 0,
    exampleCount: exampleCount,
    onReload: getLogEntryCategoryExamples
  }, logEntryCategoryExamples.map((example, exampleIndex) => /*#__PURE__*/_react.default.createElement(_category_example_message.CategoryExampleMessage, {
    key: exampleIndex,
    id: example.id,
    dataset: example.dataset,
    message: example.message,
    timeRange: timeRange,
    timestamp: example.timestamp,
    tiebreaker: example.tiebreaker,
    context: example.context
  })));
};
exports.CategoryDetailsRow = CategoryDetailsRow;