"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToFromLocation = exports.getTimeFromLocation = exports.getFromFromLocation = exports.getFilterFromLocation = void 0;
var _url_state = require("../../utils/url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimeFromLocation = location => {
  const timeParam = (0, _url_state.getParamFromQueryString)((0, _url_state.getQueryStringFromLocation)(location), 'time');
  return timeParam ? parseFloat(timeParam) : NaN;
};
exports.getTimeFromLocation = getTimeFromLocation;
const getFilterFromLocation = location => {
  const param = (0, _url_state.getParamFromQueryString)((0, _url_state.getQueryStringFromLocation)(location), 'filter');
  return param ? param : '';
};
exports.getFilterFromLocation = getFilterFromLocation;
const getToFromLocation = location => {
  const timeParam = (0, _url_state.getParamFromQueryString)((0, _url_state.getQueryStringFromLocation)(location), 'to');
  return timeParam ? parseFloat(timeParam) : NaN;
};
exports.getToFromLocation = getToFromLocation;
const getFromFromLocation = location => {
  const timeParam = (0, _url_state.getParamFromQueryString)((0, _url_state.getQueryStringFromLocation)(location), 'from');
  return timeParam ? parseFloat(timeParam) : NaN;
};
exports.getFromFromLocation = getFromFromLocation;