"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogStreamPageStateContext = exports.useLogStreamPageState = exports.LogStreamPageStateProvider = void 0;
var _react = require("@xstate/react");
var _constate = _interopRequireDefault(require("constate"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _dev_mode = require("../../../../utils/dev_mode");
var _state_machine = require("./state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogStreamPageState = ({
  kibanaQuerySettings,
  logViewStateNotifications,
  queryStringService,
  toastsService,
  filterManagerService,
  urlStateStorage,
  useDevTools = (0, _dev_mode.isDevMode)(),
  timeFilterService
}) => {
  (0, _useMount.default)(() => {
    // eslint-disable-next-line no-console
    console.log("A warning in console stating: 'The result of getSnapshot should be cached to avoid an infinite loop' is expected. This will be fixed once we can upgrade versions.");
  });
  const logStreamPageStateService = (0, _react.useInterpret)(() => (0, _state_machine.createLogStreamPageStateMachine)({
    kibanaQuerySettings,
    logViewStateNotifications,
    queryStringService,
    toastsService,
    filterManagerService,
    urlStateStorage,
    timeFilterService
  }), {
    devTools: useDevTools
  });
  return logStreamPageStateService;
};
exports.useLogStreamPageState = useLogStreamPageState;
const [LogStreamPageStateProvider, useLogStreamPageStateContext] = (0, _constate.default)(useLogStreamPageState);
exports.useLogStreamPageStateContext = useLogStreamPageStateContext;
exports.LogStreamPageStateProvider = LogStreamPageStateProvider;