"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReactQueryProvider = ReactQueryProvider;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _merge = _interopRequireDefault(require("lodash/merge"));
var _eui = require("@elastic/eui");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CONFIG = {
  defaultOptions: {
    queries: {
      keepPreviousData: true,
      refetchOnWindowFocus: false
    }
  }
};
function ReactQueryProvider({
  children,
  config = {}
}) {
  const [queryClient] = (0, _react.useState)(() => new _reactQuery.QueryClient((0, _merge.default)(DEFAULT_CONFIG, config)));
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(HideableReactQueryDevTools, null), children);
}
function HideableReactQueryDevTools() {
  const [isHidden, setIsHidden] = (0, _react.useState)(false);
  return !isHidden ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraHideableReactQueryDevToolsButton",
    iconType: "cross",
    color: "primary",
    style: {
      zIndex: 99999,
      position: 'fixed',
      bottom: '40px',
      left: '40px'
    },
    onClick: () => setIsHidden(!isHidden),
    "aria-label": "Disable React Query Dev Tools"
  }), /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  })) : null;
}