"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TryItButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react2 = require("@emotion/react");
var _beta_badge = require("./beta_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TryItButton = ({
  label,
  link,
  color = 'primary',
  experimental = false,
  hideBadge = false,
  onClick,
  ...props
}) => {
  const linkProps = (0, _public.useLinkProps)({
    ...link
  });
  const handleClick = event => {
    if (linkProps.onClick) linkProps.onClick(event);
    if (onClick) onClick(event);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "m"
  }, !hideBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": `${props['data-test-subj']}-badge`
  }, linkProps, {
    onClick: handleClick
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    css: (0, _react2.css)`
                cursor: pointer;
              `,
    color: 'accent',
    label: _i18n.i18n.translate('xpack.infra.layout.tryIt', {
      defaultMessage: 'Try it'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": props['data-test-subj']
  }, linkProps, {
    color: color,
    onClick: handleClick
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: false,
    responsive: false,
    gutterSize: "m",
    alignItems: "center"
  }, experimental && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
    iconType: "beta",
    tooltipPosition: "top"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, label)))));
};
exports.TryItButton = TryItButton;