"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageViewsFlyout = ManageViewsFlyout;
var _react = _interopRequireWildcard(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchConfig = {
  box: {
    incremental: true
  }
};
function ManageViewsFlyout({
  onClose,
  views = [],
  onSwitchView,
  onMakeDefaultView,
  onDeleteView,
  loading
}) {
  // Add name as top level property to allow in memory search
  const namedViews = (0, _react.useMemo)(() => views.map(addOwnName), [views]);
  const renderName = (name, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    key: item.id,
    "data-test-subj": "infraRenderNameButton",
    onClick: () => {
      onSwitchView(item.id);
      onClose();
    }
  }, name);
  const renderDeleteAction = item => {
    return /*#__PURE__*/_react.default.createElement(DeleteConfimation, {
      key: item.id,
      isDisabled: item.attributes.isDefault,
      onConfirm: () => {
        onDeleteView(item.id);
      }
    });
  };
  const renderMakeDefaultAction = item => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      key: item.id,
      "data-test-subj": "infraRenderMakeDefaultActionButton",
      iconType: item.attributes.isDefault ? 'starFilled' : 'starEmpty',
      size: "s",
      onClick: () => {
        onMakeDefaultView(item.id);
      }
    });
  };
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.infra.openView.columnNames.name', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    truncateText: true,
    render: renderName
  }, {
    name: _i18n.i18n.translate('xpack.infra.openView.columnNames.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: renderMakeDefaultAction
    }, {
      available: item => !item.attributes.isStatic,
      render: renderDeleteAction
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "loadViewsFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Manage saved views",
    id: "xpack.infra.openView.flyoutHeader"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: namedViews,
    columns: columns,
    loading: loading,
    search: searchConfig,
    pagination: true,
    sorting: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelSavedViewModal",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Cancel",
    id: "xpack.infra.openView.cancelButton"
  })))));
}
const DeleteConfimation = ({
  isDisabled,
  onConfirm
}) => {
  const [isConfirmVisible, toggleVisibility] = (0, _useToggle.default)(false);
  return isConfirmVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: toggleVisibility,
    "data-test-subj": "hideConfirm"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "cancel",
    id: "xpack.infra.waffle.savedViews.cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isDisabled,
    fill: true,
    iconType: "trash",
    color: "danger",
    onClick: onConfirm,
    "data-test-subj": "showConfirm"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Delete view?",
    id: "xpack.infra.openView.actionNames.deleteConfirmation"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraDeleteConfimationButton",
    iconType: "trash",
    color: "danger",
    size: "s",
    onClick: toggleVisibility
  });
};

/**
 * Helpers
 */
const addOwnName = view => ({
  ...view,
  name: view.attributes.name
});