"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogAnalysisSetupFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _log_entry_categories_setup_view = require("./log_entry_categories_setup_view");
var _log_entry_rate_setup_view = require("./log_entry_rate_setup_view");
var _module_list = require("./module_list");
var _setup_flyout_state = require("./setup_flyout_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FLYOUT_HEADING_ID = 'logAnalysisSetupFlyoutHeading';
const LogAnalysisSetupFlyout = ({
  allowedModules = _setup_flyout_state.moduleIds
}) => {
  const {
    closeFlyout,
    flyoutView,
    showModuleList,
    showModuleSetup
  } = (0, _setup_flyout_state.useLogAnalysisSetupFlyoutStateContext)();
  if (flyoutView.view === 'hidden') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "aria-labelledby": FLYOUT_HEADING_ID,
    maxWidth: 800,
    onClose: closeFlyout,
    "data-test-subj": "infraLogAnalysisSetupFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: FLYOUT_HEADING_ID
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.setupFlyoutTitle",
    defaultMessage: "Anomaly detection with Machine Learning"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, flyoutView.view === 'moduleList' ? /*#__PURE__*/_react.default.createElement(_module_list.LogAnalysisModuleList, {
    onViewModuleSetup: showModuleSetup
  }) : flyoutView.view === 'moduleSetup' && allowedModules.includes(flyoutView.module) ? /*#__PURE__*/_react.default.createElement(ModuleSetupView, {
    moduleId: flyoutView.module,
    onClose: closeFlyout,
    onViewModuleList: allowedModules.length > 1 ? showModuleList : undefined
  }) : null));
};
exports.LogAnalysisSetupFlyout = LogAnalysisSetupFlyout;
const ModuleSetupView = ({
  moduleId,
  onClose,
  onViewModuleList
}) => {
  switch (moduleId) {
    case 'logs_ui_analysis':
      return /*#__PURE__*/_react.default.createElement(LogAnalysisSetupFlyoutSubPage, {
        onViewModuleList: onViewModuleList
      }, /*#__PURE__*/_react.default.createElement(_log_entry_rate_setup_view.LogEntryRateSetupView, {
        onClose: onClose
      }));
    case 'logs_ui_categories':
      return /*#__PURE__*/_react.default.createElement(LogAnalysisSetupFlyoutSubPage, {
        onViewModuleList: onViewModuleList
      }, /*#__PURE__*/_react.default.createElement(_log_entry_categories_setup_view.LogEntryCategoriesSetupView, {
        onClose: onClose
      }));
  }
};
const LogAnalysisSetupFlyoutSubPage = ({
  children,
  onViewModuleList
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  direction: "column",
  gutterSize: "none"
}, onViewModuleList ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": "infraLogAnalysisSetupFlyoutSubPageAllMachineLearningJobsButton",
  flush: "left",
  iconSide: "left",
  iconType: "arrowLeft",
  onClick: onViewModuleList
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.analysis.setupFlyoutGotoListButtonLabel",
  defaultMessage: "All Machine Learning jobs"
}))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children));