"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineLogViewSplashPrompt = exports.InlineLogViewSplashPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _page_template = require("../page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InlineLogViewSplashPage = props => {
  const {
    revertToDefaultLogView,
    ...templateProps
  } = props;
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, (0, _extends2.default)({}, templateProps, {
    isEmptyState: true
  }), /*#__PURE__*/_react.default.createElement(InlineLogViewSplashPrompt, {
    revertToDefaultLogView: revertToDefaultLogView
  }));
};
exports.InlineLogViewSplashPage = InlineLogViewSplashPage;
const InlineLogViewSplashPrompt = ({
  revertToDefaultLogView
}) => {
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.splash.inlineLogView.title",
    defaultMessage: "Switch to a persisted Log View"
  });
  const ctaButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraInlineLogViewSplashPromptRevertToDefaultPersistedLogViewButton",
    fullWidth: false,
    fill: true,
    onClick: revertToDefaultLogView
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.splash.inlineLogView.buttonText",
    defaultMessage: "Revert to default (persisted) Log View"
  }));
  const description = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.splash.inlineLogView.description",
    defaultMessage: "This feature does not support inline Log Views"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: 'visLine',
    title: /*#__PURE__*/_react.default.createElement("h2", null, title),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, description)),
    actions: ctaButton
  });
};
exports.InlineLogViewSplashPrompt = InlineLogViewSplashPrompt;