"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsSectionCompact = exports.MetricsSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _section_titles = require("../../../components/section_titles");
var _use_metadata_state = require("../../../hooks/use_metadata_state");
var _metrics_grid = require("./metrics_grid");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsSection = ({
  assetName,
  metricsDataView,
  logsDataView,
  dateRange
}) => {
  var _dashboards$hosts$cha, _dashboards$hosts, _dashboards$kubernete, _dashboards$kubernete2, _dashboards$kubernete3;
  const model = (0, _common.findInventoryModel)('host');
  const {
    value
  } = (0, _useAsync.default)(() => {
    return model.metrics.getDashboards();
  });
  const dashboards = (0, _react.useMemo)(() => ({
    hosts: value === null || value === void 0 ? void 0 : value.assetDetails.get({
      metricsDataView,
      logsDataView
    }),
    kubernetes: value === null || value === void 0 ? void 0 : value.assetDetailsKubernetesNode.get({
      metricsDataView
    })
  }), [logsDataView, metricsDataView, value === null || value === void 0 ? void 0 : value.assetDetails, value === null || value === void 0 ? void 0 : value.assetDetailsKubernetesNode]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(Section, {
    title: _section_titles.MetricsSectionTitle
  }, /*#__PURE__*/_react.default.createElement(_metrics_grid.MetricsGrid, {
    assetName: assetName,
    dateRange: dateRange,
    "data-test-subj": "infraAssetDetailsHostMetricsChart",
    charts: (_dashboards$hosts$cha = (_dashboards$hosts = dashboards.hosts) === null || _dashboards$hosts === void 0 ? void 0 : _dashboards$hosts.charts) !== null && _dashboards$hosts$cha !== void 0 ? _dashboards$hosts$cha : [],
    filterFieldName: model.fields.name
  })), /*#__PURE__*/_react.default.createElement(Section, {
    dependsOn: dashboards === null || dashboards === void 0 ? void 0 : (_dashboards$kubernete = dashboards.kubernetes) === null || _dashboards$kubernete === void 0 ? void 0 : _dashboards$kubernete.dependsOn,
    title: _section_titles.KubernetesMetricsSectionTitle
  }, /*#__PURE__*/_react.default.createElement(_metrics_grid.MetricsGrid, {
    assetName: assetName,
    dateRange: dateRange,
    "data-test-subj": "infraAssetDetailsKubernetesMetricsChart",
    charts: (_dashboards$kubernete2 = (_dashboards$kubernete3 = dashboards.kubernetes) === null || _dashboards$kubernete3 === void 0 ? void 0 : _dashboards$kubernete3.charts) !== null && _dashboards$kubernete2 !== void 0 ? _dashboards$kubernete2 : [],
    filterFieldName: model.fields.name
  })));
};
exports.MetricsSection = MetricsSection;
const MetricsSectionCompact = ({
  assetName,
  metricsDataView,
  logsDataView,
  dateRange
}) => {
  const model = (0, _common.findInventoryModel)('host');
  const {
    value
  } = (0, _useAsync.default)(() => {
    return model.metrics.getDashboards();
  });
  const charts = (0, _react.useMemo)(() => {
    var _value$assetDetailsFl;
    return (_value$assetDetailsFl = value === null || value === void 0 ? void 0 : value.assetDetailsFlyout.get({
      metricsDataView,
      logsDataView
    }).charts) !== null && _value$assetDetailsFl !== void 0 ? _value$assetDetailsFl : [];
  }, [metricsDataView, logsDataView, value === null || value === void 0 ? void 0 : value.assetDetailsFlyout]);
  return /*#__PURE__*/_react.default.createElement(Section, {
    title: _section_titles.MetricsSectionTitle
  }, /*#__PURE__*/_react.default.createElement(_metrics_grid.MetricsGrid, {
    assetName: assetName,
    dateRange: dateRange,
    filterFieldName: model.fields.name,
    charts: charts,
    "data-test-subj": "infraAssetDetailsHostMetricsChart"
  }));
};
exports.MetricsSectionCompact = MetricsSectionCompact;
const Section = ({
  title,
  dependsOn = [],
  children
}) => {
  const Title = title;
  const {
    metadata
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const shouldRender = (0, _react.useMemo)(() => dependsOn.length === 0 || dependsOn.some(p => {
    var _metadata$features;
    return ((_metadata$features = metadata === null || metadata === void 0 ? void 0 : metadata.features) !== null && _metadata$features !== void 0 ? _metadata$features : []).some(f => f.name === p);
  }), [dependsOn, metadata === null || metadata === void 0 ? void 0 : metadata.features]);
  return shouldRender ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Title, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, children)) : null;
};