"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTemplateHeaderBreadcrumbs = exports.usePageHeader = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _plugin_config_context = require("../../../containers/plugin_config_context");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_profiling_integration_setting = require("../../../hooks/use_profiling_integration_setting");
var _constants = require("../constants");
var _links = require("../links");
var _types = require("../types");
var _use_asset_details_render_props = require("./use_asset_details_render_props");
var _use_tab_switcher = require("./use_tab_switcher");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePageHeader = (tabs = [], links = []) => {
  const {
    rightSideItems
  } = useRightSideItems(links);
  const {
    tabEntries
  } = useTabs(tabs);
  const {
    breadcrumbs
  } = useTemplateHeaderBreadcrumbs();
  return {
    rightSideItems,
    tabEntries,
    breadcrumbs
  };
};
exports.usePageHeader = usePageHeader;
const useTemplateHeaderBreadcrumbs = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      application: {
        navigateToApp
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const onClick = e => {
    if (location.state) {
      navigateToApp(location.state.originAppId, {
        replace: true,
        path: `${location.state.originPathname}${location.state.originSearch}`
      });
    } else {
      history.goBack();
    }
    e.preventDefault();
  };
  const breadcrumbs =
  // If there is a state object in location, it's persisted in case the page is opened in a new tab or after page refresh
  // With that, we can show the return button. Otherwise, it will be hidden (ex: the user opened a shared URL or opened the page from their bookmarks)
  location.state || history.length > 1 ? [{
    text: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "arrowLeft"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.header.return",
      defaultMessage: "Return"
    }))),
    color: 'primary',
    'aria-current': false,
    'data-test-subj': 'infraAssetDetailsReturnButton',
    href: '#',
    onClick
  }] : [];
  return {
    breadcrumbs
  };
};
exports.useTemplateHeaderBreadcrumbs = useTemplateHeaderBreadcrumbs;
const useRightSideItems = links => {
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const topCornerLinkComponents = (0, _react.useMemo)(() => ({
    nodeDetails: /*#__PURE__*/_react.default.createElement(_links.LinkToNodeDetails, {
      assetId: asset.id,
      assetName: asset.name,
      assetType: asset.type
    }),
    alertRule: /*#__PURE__*/_react.default.createElement(_links.LinkToAlertsRule, null),
    apmServices: /*#__PURE__*/_react.default.createElement(_links.LinkToApmServices, {
      assetName: asset.name,
      apmField: _constants.APM_HOST_FILTER_FIELD
    })
  }), [asset.id, asset.name, asset.type]);
  const rightSideItems = (0, _react.useMemo)(() => links === null || links === void 0 ? void 0 : links.map(link => topCornerLinkComponents[link]), [links, topCornerLinkComponents]);
  return {
    rightSideItems
  };
};
const useFeatureFlagTabs = () => {
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  const isProfilingEnabled = (0, _use_profiling_integration_setting.useProfilingIntegrationSetting)();
  const featureFlagControlledTabs = (0, _react.useMemo)(() => ({
    [_types.ContentTabIds.OSQUERY]: featureFlags.osqueryEnabled,
    [_types.ContentTabIds.PROFILING]: isProfilingEnabled
  }), [featureFlags.osqueryEnabled, isProfilingEnabled]);
  const isTabEnabled = (0, _react.useCallback)(tabItem => {
    var _featureFlagControlle;
    return (_featureFlagControlle = featureFlagControlledTabs[tabItem.id]) !== null && _featureFlagControlle !== void 0 ? _featureFlagControlle : true;
  }, [featureFlagControlledTabs]);
  return {
    isTabEnabled
  };
};
const useTabs = tabs => {
  const {
    showTab,
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    isTabEnabled
  } = useFeatureFlagTabs();
  const onTabClick = (0, _react.useCallback)(tabId => {
    showTab(tabId);
  }, [showTab]);
  const apmTracesMenuItemLinkProps = (0, _public.useLinkProps)({
    app: 'apm',
    hash: 'traces',
    search: {
      kuery: `${_constants.APM_HOST_FILTER_FIELD}:"${asset.name}"`
    }
  });
  const getTabToApmTraces = (0, _react.useCallback)(name => ({
    ...apmTracesMenuItemLinkProps,
    'data-test-subj': 'infraAssetDetailsApmServicesLinkTab',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "popout"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, name))
  }), [apmTracesMenuItemLinkProps]);
  const tabEntries = (0, _react.useMemo)(() => tabs.filter(isTabEnabled).map(({
    name,
    ...tab
  }) => {
    if (tab.id === _types.ContentTabIds.LINK_TO_APM) {
      return getTabToApmTraces(name);
    }
    return {
      ...tab,
      'data-test-subj': `infraAssetDetails${(0, _lodash.capitalize)(tab.id)}Tab`,
      onClick: () => onTabClick(tab.id),
      isSelected: tab.id === activeTabId,
      label: name
    };
  }), [activeTabId, isTabEnabled, getTabToApmTraces, onTabClick, tabs]);
  return {
    tabEntries
  };
};