"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsSectionTitle = exports.MetadataSectionTitle = exports.KubernetesMetricsSectionTitle = exports.AlertsSectionTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lens = require("../../lens");
var _popover = require("../tabs/common/popover");
var _alerts_tooltip_content = require("./alerts_tooltip_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SectionTitle = ({
  title,
  'data-test-subj': dataTestSubject
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": dataTestSubject
  }, /*#__PURE__*/_react.default.createElement("span", null, title));
};
const TitleWithTooltip = ({
  title,
  'data-test-subj': dataTestSubject,
  tooltipTestSubj,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(SectionTitle, {
    title: title,
    "data-test-subj": dataTestSubject
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    icon: "iInCircle",
    "data-test-subj": tooltipTestSubj
  }, children)));
};
const MetricsSectionTitle = () => {
  return /*#__PURE__*/_react.default.createElement(TitleWithTooltip, {
    title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metricsSectionTitle', {
      defaultMessage: 'Metrics'
    }),
    tooltipTestSubj: "infraAssetDetailsMetricsPopoverButton"
  }, /*#__PURE__*/_react.default.createElement(_lens.HostMetricsExplanationContent, null));
};
exports.MetricsSectionTitle = MetricsSectionTitle;
const KubernetesMetricsSectionTitle = () => /*#__PURE__*/_react.default.createElement(SectionTitle, {
  title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.kubernetesMetricsSectionTitle', {
    defaultMessage: 'Kubernetes Overview'
  })
});
exports.KubernetesMetricsSectionTitle = KubernetesMetricsSectionTitle;
const MetadataSectionTitle = () => /*#__PURE__*/_react.default.createElement(SectionTitle, {
  title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataSectionTitle', {
    defaultMessage: 'Metadata'
  }),
  "data-test-subj": "infraAssetDetailsMetadataTitle"
});
exports.MetadataSectionTitle = MetadataSectionTitle;
const AlertsSectionTitle = () => {
  return /*#__PURE__*/_react.default.createElement(TitleWithTooltip, {
    title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.alertsSectionTitle', {
      defaultMessage: 'Alerts'
    }),
    "data-test-subj": "infraAssetDetailsAlertsTitle",
    tooltipTestSubj: "infraAssetDetailsAlertsPopoverButton"
  }, /*#__PURE__*/_react.default.createElement(_alerts_tooltip_content.AlertsTooltipContent, null));
};
exports.AlertsSectionTitle = AlertsSectionTitle;