"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricNotAvailableExplanationTooltip = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _popover = require("../tabs/common/popover");
var _use_date_picker = require("../hooks/use_date_picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricNotAvailableExplanationTooltip = ({
  metricName
}) => {
  const {
    getDateRangeInTimestamp
  } = (0, _use_date_picker.useDatePickerContext)();
  const dateFromRange = new Date(getDateRangeInTimestamp().to);
  return /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    iconSize: "s",
    iconColor: "subdued",
    icon: "questionInCircle",
    "data-test-subj": "infraAssetDetailsMetricNotAvailablePopoverButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.tooltip.metricNotAvailableTitle",
    defaultMessage: "No {metric} value detected for the 1 minute preceding {date} @ {time}.",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: dateFromRange,
        month: "short",
        day: "numeric",
        year: "numeric"
      }),
      time: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: dateFromRange,
        hour12: false,
        hour: "2-digit",
        minute: "2-digit",
        second: "2-digit"
      }),
      metric: metricName
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.tooltip.metricNotAvailableActionText",
    defaultMessage: "Try changing the selected time period or check the data collection method for this host."
  }))));
};
exports.MetricNotAvailableExplanationTooltip = MetricNotAvailableExplanationTooltip;