"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Threshold = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../common/alerting/logs/log_threshold/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const thresholdPrefix = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.thresholdPrefix', {
  defaultMessage: 'is'
});
const popoverTitle = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.thresholdPopoverTitle', {
  defaultMessage: 'Threshold'
});
const getComparatorOptions = () => {
  return [{
    value: _types.Comparator.LT,
    text: _types.ComparatorToi18nMap[_types.Comparator.LT]
  }, {
    value: _types.Comparator.LT_OR_EQ,
    text: _types.ComparatorToi18nMap[_types.Comparator.LT_OR_EQ]
  }, {
    value: _types.Comparator.GT,
    text: _types.ComparatorToi18nMap[_types.Comparator.GT]
  }, {
    value: _types.Comparator.GT_OR_EQ,
    text: _types.ComparatorToi18nMap[_types.Comparator.GT_OR_EQ]
  }];
};
const Threshold = ({
  comparator,
  value,
  updateThreshold,
  errors
}) => {
  const [isThresholdPopoverOpen, setThresholdPopoverOpenState] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "threshold",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: thresholdPrefix,
      uppercase: true,
      value: `${comparator ? _types.ComparatorToi18nMap[comparator] : ''} ${typeof value === 'number' ? value : ''}`,
      isActive: isThresholdPopoverOpen,
      onClick: () => setThresholdPopoverOpenState(!isThresholdPopoverOpen)
    }),
    isOpen: isThresholdPopoverOpen,
    closePopover: () => setThresholdPopoverOpenState(false),
    ownFocus: true,
    panelPaddingSize: "s",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, popoverTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraThresholdSelect",
    compressed: true,
    value: comparator,
    onChange: e => updateThreshold({
      comparator: e.target.value
    }),
    options: getComparatorOptions()
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: errors.value.length > 0,
    error: errors.value
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "infraThresholdFieldNumber",
    compressed: true,
    value: value,
    onChange: e => {
      const number = parseFloat(e.target.value);
      updateThreshold({
        value: (0, _lodash.isNumber)(number) && (0, _lodash.isFinite)(number) ? number : undefined
      });
    }
  }))))))));
};
exports.Threshold = Threshold;