"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _lodash = require("lodash");
var _public = require("@kbn/logs-shared-plugin/public");
var _use_kibana = require("../../../../hooks/use_kibana");
var _log_threshold = require("../../../../../common/alerting/logs/log_threshold");
var _threshold = require("../../../common/components/threshold");
var _log_rate_analysis = require("./components/log_rate_analysis");
var _threhsold_chart = require("./components/threhsold_chart");
var _use_license = require("../../../../hooks/use_license");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const LogsHistoryChart = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/logs_history_chart'))));
const formatThreshold = threshold => String(threshold);
const AlertDetailsAppSection = ({
  rule,
  alert,
  setAlertSummaryFields
}) => {
  const {
    logsShared
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const theme = (0, _react2.useTheme)();
  const timeRange = (0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alert.fields[_ruleDataUtils.ALERT_START], alert.fields[_ruleDataUtils.ALERT_END]);
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]).valueOf() : undefined;
  const interval = `${rule.params.timeSize}${rule.params.timeUnit}`;
  const thresholdFill = convertComparatorToFill(rule.params.count.comparator);
  const filter = rule.params.groupBy ? rule.params.groupBy.map(field => {
    const value = (0, _lodash.get)(alert.fields[_ruleDataUtils.ALERT_CONTEXT], ['groupByKeys', ...field.split('.')], null);
    return value ? `${field} : "${value}"` : null;
  }).filter(_lodash.identity).join(' AND ') : '';
  const {
    derivedDataView
  } = (0, _public.useLogView)({
    initialLogViewReference: rule.params.logView,
    logViews: logsShared.logViews.client
  });
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const hasLicenseForLogRateAnalysis = hasAtLeast('platinum');
  (0, _react.useEffect)(() => {
    var _rule$params$groupBy;
    /**
     * The `CriterionPreview` chart shows all the series/data stacked when there is a GroupBy in the rule parameters.
     * e.g., `host.name`, the chart will show stacks of data by hostname.
     * We only need the chart to show the series that is related to the selected alert.
     * The chart series are built based on the GroupBy in the rule params
     * Each series have an id which is the just a joining of fields value of the GroupBy `getChartGroupNames`
     * We filter down the series using this group name
     */
    const alertFieldsFromGroupBy = ((_rule$params$groupBy = rule.params.groupBy) === null || _rule$params$groupBy === void 0 ? void 0 : _rule$params$groupBy.reduce((selectedFields, field) => ({
      ...selectedFields,
      ...{
        [field]: (0, _lodash.get)(alert.fields[_ruleDataUtils.ALERT_CONTEXT], ['groupByKeys', ...field.split('.')], null)
      }
    }), {})) || {};
    const alertSummaryFields = Object.entries(alertFieldsFromGroupBy).map(([label, value]) => ({
      label,
      value
    }));
    setAlertSummaryFields(alertSummaryFields);
  }, [alert.fields, rule.params.groupBy, setAlertSummaryFields]);
  const getLogRatioChart = () => {
    if ((0, _log_threshold.isRatioRule)(rule.params.criteria)) {
      var _alert$fields$ALERT_E;
      const numeratorKql = rule.params.criteria[0].map(criteria => convertCriteriaToKQL(criteria)).join(' AND ');
      const denominatorKql = rule.params.criteria[1].map(criteria => convertCriteriaToKQL(criteria)).join(' AND ');
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasBorder: true,
        "data-test-subj": "logsRatioChartAlertDetails"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chart.ratioTitle', {
        defaultMessage: 'Ratio of QUERY A TO QUERY B'
      }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          maxHeight: 120
        },
        grow: 1
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
        title: `Threshold breached`,
        chartProps: {
          theme,
          baseTheme: _charts.LIGHT_THEME
        },
        comparator: _log_threshold.ComparatorToi18nSymbolsMap[rule.params.count.comparator],
        id: 'threshold-ratio-chart',
        threshold: rule.params.count.value,
        value: Number((_alert$fields$ALERT_E = alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE]) === null || _alert$fields$ALERT_E === void 0 ? void 0 : _alert$fields$ALERT_E.toFixed(2)),
        valueFormatter: formatThreshold
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 5
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), derivedDataView && /*#__PURE__*/_react.default.createElement(_threhsold_chart.LogThresholdRatioChart, {
        filter: filter,
        numeratorKql: numeratorKql,
        denominatorKql: denominatorKql,
        threshold: {
          value: rule.params.count.value,
          fill: thresholdFill
        },
        timeRange: timeRange,
        alertRange: {
          from: alert.start,
          to: alertEnd
        },
        index: {
          pattern: derivedDataView.getIndexPattern(),
          timestampField: derivedDataView.timeFieldName || '@timestamp'
        },
        height: 150,
        interval: interval
      }))));
    } else return null;
  };
  const getLogCountChart = () => {
    if (!!rule.params.criteria && !(0, _log_threshold.isRatioRule)(rule.params.criteria)) {
      const kql = rule.params.criteria.map(criteria => convertCriteriaToKQL(criteria)).join(' AND ');
      const criteriaAsText = rule.params.criteria.map(criteria => {
        if (!criteria.field || !criteria.comparator || !criteria.value) {
          return '';
        }
        return `${criteria.field}  ${_log_threshold.ComparatorToi18nMap[criteria.comparator]} ${criteria.value}`;
      }).filter(text => text).join(' AND ');
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasBorder: true,
        "data-test-subj": `logsCountChartAlertDetails`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chart.chartTitle', {
        defaultMessage: 'Logs for {criteria}',
        values: {
          criteria: criteriaAsText
        }
      }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          maxHeight: 120
        },
        grow: 1
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
        title: `Threshold breached`,
        chartProps: {
          theme,
          baseTheme: _charts.LIGHT_THEME
        },
        comparator: _log_threshold.ComparatorToi18nSymbolsMap[rule.params.count.comparator],
        id: "logCountThreshold",
        threshold: rule.params.count.value,
        value: Number(alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE]),
        valueFormatter: formatThreshold
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 5
      }, derivedDataView && /*#__PURE__*/_react.default.createElement(_threhsold_chart.LogThresholdCountChart, {
        filter: filter,
        kql: kql,
        threshold: {
          value: rule.params.count.value,
          fill: thresholdFill
        },
        timeRange: timeRange,
        alertRange: {
          from: alert.start,
          to: alertEnd
        },
        index: {
          pattern: derivedDataView.getIndexPattern(),
          timestampField: derivedDataView.timeFieldName || '@timestamp'
        },
        height: 150,
        interval: interval
      }))));
    } else return null;
  };
  const getLogsHistoryChart = () => {
    return rule && rule.params.criteria.length === 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(LogsHistoryChart, {
      rule: {
        ...rule,
        params: {
          ...rule.params,
          timeSize: 12,
          timeUnit: 'h'
        }
      }
    }));
  };
  const getLogRateAnalysisSection = () => {
    return hasLicenseForLogRateAnalysis ? /*#__PURE__*/_react.default.createElement(_log_rate_analysis.LogRateAnalysis, {
      rule: rule,
      alert: alert
    }) : null;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "logsThresholdAlertDetailsPage"
  }, getLogRatioChart(), getLogCountChart(), getLogRateAnalysisSection(), getLogsHistoryChart());
};
function convertComparatorToFill(comparator) {
  switch (comparator) {
    case _log_threshold.Comparator.GT:
    case _log_threshold.Comparator.GT_OR_EQ:
      return 'above';
    default:
      return 'below';
  }
}
function convertCriteriaToKQL(criteria) {
  if (!criteria.value || !criteria.comparator || !criteria.field) {
    return '';
  }
  switch (criteria.comparator) {
    case _log_threshold.Comparator.MATCH:
    case _log_threshold.Comparator.EQ:
      return `${criteria.field} : "${criteria.value}"`;
    case _log_threshold.Comparator.NOT_MATCH:
    case _log_threshold.Comparator.NOT_EQ:
      return `NOT ${criteria.field} : "${criteria.value}"`;
    case _log_threshold.Comparator.MATCH_PHRASE:
      return `${criteria.field} : ${criteria.value}`;
    case _log_threshold.Comparator.NOT_MATCH_PHRASE:
      return `NOT ${criteria.field} : ${criteria.value}`;
    case _log_threshold.Comparator.GT:
      return `${criteria.field} > ${criteria.value}`;
    case _log_threshold.Comparator.GT_OR_EQ:
      return `${criteria.field} >= ${criteria.value}`;
    case _log_threshold.Comparator.LT:
      return `${criteria.field} < ${criteria.value}`;
    case _log_threshold.Comparator.LT_OR_EQ:
      return `${criteria.field} <= ${criteria.value}`;
    default:
      return '';
  }
}

// eslint-disable-next-line import/no-default-export
var _default = AlertDetailsAppSection;
exports.default = _default;
module.exports = exports.default;