"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupBySelector = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupBySelector = ({
  onChange,
  fields,
  selectedGroups = [],
  label,
  placeholder
}) => {
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    const groupBy = selectedOptions.map(option => option.label);
    onChange(groupBy);
  }, [onChange]);
  const formattedSelectedGroups = (0, _react.useMemo)(() => {
    return selectedGroups.map(group => ({
      label: group
    }));
  }, [selectedGroups]);
  const options = (0, _react.useMemo)(() => {
    return fields.filter(field => field.aggregatable).map(field => ({
      label: field.name
    }));
  }, [fields]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: placeholder,
    "aria-label": label,
    fullWidth: true,
    singleSelection: false,
    selectedOptions: formattedSelectedGroups,
    options: options,
    onChange: handleChange,
    isClearable: true
  }));
};
exports.GroupBySelector = GroupBySelector;