"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByExpression = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _selector = require("./selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_GROUP_BY_LABEL = _i18n.i18n.translate('xpack.infra.alerting.alertFlyout.groupByLabel', {
  defaultMessage: 'Group By'
});
const EVERYTHING_PLACEHOLDER = _i18n.i18n.translate('xpack.infra.alerting.alertFlyout.groupBy.placeholder', {
  defaultMessage: 'Nothing (ungrouped)'
});
const GroupByExpression = ({
  selectedGroups = [],
  fields,
  label,
  onChange
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const expressionValue = (0, _react.useMemo)(() => {
    return selectedGroups.length > 0 ? selectedGroups.join(', ') : EVERYTHING_PLACEHOLDER;
  }, [selectedGroups]);
  const labelProp = label !== null && label !== void 0 ? label : DEFAULT_GROUP_BY_LABEL;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "groupByExpression",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: labelProp,
      uppercase: true,
      value: expressionValue,
      isActive: isPopoverOpen,
      onClick: () => setIsPopoverOpen(!isPopoverOpen)
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    ownFocus: true,
    panelPaddingSize: "s",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      zIndex: 11000
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, labelProp), /*#__PURE__*/_react.default.createElement(_selector.GroupBySelector, {
    selectedGroups: selectedGroups,
    onChange: onChange,
    fields: fields,
    label: labelProp,
    placeholder: EVERYTHING_PLACEHOLDER
  })))));
};
exports.GroupByExpression = GroupByExpression;