"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerListRoute = registerListRoute;
var _ = require("..");
var _enrich_policies = require("../../../lib/enrich_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerListRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  router.get({
    path: (0, _.addInternalBasePath)('/enrich_policies'),
    validate: false
  }, async (context, request, response) => {
    const client = (await context.core).elasticsearch.client;
    try {
      const policies = await _enrich_policies.enrichPoliciesActions.fetchAll(client);
      return response.ok({
        body: policies
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}