"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDeleteRoute = registerDeleteRoute;
var _configSchema = require("@kbn/config-schema");
var _ = require("..");
var _enrich_policies = require("../../../lib/enrich_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const paramsSchema = _configSchema.schema.object({
  name: _configSchema.schema.string()
});
function registerDeleteRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  router.delete({
    path: (0, _.addInternalBasePath)('/enrich_policies/{name}'),
    validate: {
      params: paramsSchema
    }
  }, async (context, request, response) => {
    const {
      name
    } = request.params;
    const client = (await context.core).elasticsearch.client;
    try {
      const res = await _enrich_policies.enrichPoliciesActions.remove(client, name);
      return response.ok({
        body: res
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}