"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../services");
var _breadcrumbs = require("../../../../services/breadcrumbs");
var _details_page_settings_content = require("./details_page_settings_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsPageSettings = ({
  indexName,
  isIndexOpen
}) => {
  const {
    isLoading,
    data,
    error,
    resendRequest
  } = (0, _services.useLoadIndexSettings)(indexName);
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.indexDetailsSettings);
  }, []);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.settings.loadingDescription",
      defaultMessage: "Loading index settings\u2026"
    }));
  }
  if (error || !data) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      "data-test-subj": "indexDetailsSettingsError",
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.errorTitle",
        defaultMessage: "Unable to load index settings"
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.errorDescription",
        defaultMessage: "We encountered an error loading settings for index {indexName}. Make sure that the index name in the URL is correct and try again.",
        values: {
          indexName
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconSide: "right",
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger",
        "data-test-subj": "indexDetailsSettingsReloadButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.reloadButtonLabel",
        defaultMessage: "Reload"
      })))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_details_page_settings_content.DetailsPageSettingsContent, {
    isIndexOpen: isIndexOpen,
    data: data,
    indexName: indexName,
    reloadIndexSettings: resendRequest
  });
};
exports.DetailsPageSettings = DetailsPageSettings;