"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeletePolicyModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../services/api");
var _app_context = require("../../../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeletePolicyModal = ({
  policyToDelete,
  callback
}) => {
  const mounted = (0, _react.useRef)(false);
  const {
    services: {
      notificationService
    }
  } = (0, _app_context.useAppContext)();
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);

  // Since the async action of this component needs to set state after unmounting,
  // we need to track the mounted state of this component to avoid a memory leak.
  (0, _react.useEffect)(() => {
    mounted.current = true;
    return () => {
      mounted.current = false;
    };
  }, []);
  const handleDeletePolicy = () => {
    setIsDeleting(true);
    (0, _api.deleteEnrichPolicy)(policyToDelete).then(({
      data,
      error
    }) => {
      if (data) {
        const successMessage = _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.successDeleteNotificationMessage', {
          defaultMessage: 'Deleted {policyToDelete}',
          values: {
            policyToDelete
          }
        });
        notificationService.showSuccessToast(successMessage);
        return callback({
          hasDeletedPolicy: true
        });
      }
      if (error) {
        const errorMessage = _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.errorDeleteNotificationMessage', {
          defaultMessage: "Error deleting enrich policy: '{error}'",
          values: {
            error: error.message
          }
        });
        notificationService.showDangerToast(errorMessage);
      }
      callback();
    }).finally(() => {
      if (mounted.current) {
        setIsDeleting(false);
      }
    });
  };
  const handleOnCancel = () => {
    callback();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    "data-test-subj": "deletePolicyModal",
    title: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.confirmTitle', {
      defaultMessage: 'Delete enrich policy'
    }),
    onCancel: handleOnCancel,
    onConfirm: handleDeletePolicy,
    cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.deleteButton', {
      defaultMessage: 'Delete'
    }),
    confirmButtonDisabled: isDeleting
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicies.deleteModal.bodyCopy",
    defaultMessage: "You are about to delete the enrich policy {policy}. This action is irreversible.",
    values: {
      policy: /*#__PURE__*/_react.default.createElement("strong", null, policyToDelete)
    }
  })));
};
exports.DeletePolicyModal = DeletePolicyModal;